<?php
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * first load the admin styles for this options page
 */
function imgwize_add_init() {
    wp_enqueue_style( 'imgwize-admin-style', get_template_directory_uri() . '/include/imgwize-admin-style.css', false, '1.1' );
    }
    add_action( 'admin_enqueue_scripts', 'imgwize_add_init' );
    /*
     * color picker add on
     */

add_action( 'admin_enqueue_scripts', 'imgwize_add_color_picker' );
function imgwize_add_color_picker() {
    // Add the color picker css file       
    wp_enqueue_style( 'wp-color-picker' ); 
    // Include our custom jQuery file with WordPress Color Picker dependency
    wp_enqueue_script( 'wp-color-picker-script', get_template_directory_uri() . '/js/custom-script.js', array( 'wp-color-picker' ), false, true );
}

/**
* This function introduces the theme options into the 'Appearance' menu and into a top-level
* 'imgwize Theme' menu.
*/
function imgwize_options_theme_menu() {
add_theme_page(
__( 'ImgWize Theme', 'imgwize' ),     // The title to be displayed in the browser window for this page.
__( 'ImgWize Options', 'imgwize' ),   // The text to be displayed for this menu item
'administrator',	             // Which type of users can see this menu item
'imgwize_theme_options',	    // The unique ID - that is, the slug - for this menu item
'imgwize_theme_display'	           // The name of the function to call when rendering this menu's page
);

} // end imgwize_options_theme_menu
add_action( 'admin_menu', 'imgwize_options_theme_menu' );
/**
* Renders a simple page to display for the theme menu defined above.
*/
function imgwize_theme_display( $active_tab = 'input_options' ) {
?>
<div class="wrap">
    <div id="icon-themes" class="icon32"></div>
        <h2><?php _e( 'ImgWize Theme Options', 'imgwize' ); ?></h2>
        <?php settings_errors(); ?>
            <?php 
            if( isset( $_GET[ 'tab' ] ) ) {
            $active_tab = esc_html( $_GET[ 'tab' ] );
            }  else {
                $active_tab = 'social_options';
                } ?>

            <h2 class="nav-tab-wrapper">

<a href="?page=imgwize_theme_options&tab=social_options" class="nav-tab <?php echo $active_tab == 'social_options' ? 'nav-tab-active' : ''; ?>"><?php _e( 'Social Options', 'imgwize' ); ?></a>
<a href="?page=imgwize_theme_options&tab=input_options" class="nav-tab <?php echo $active_tab == 'input_options' ? 'nav-tab-active' : ''; ?>"><?php _e( 'Theme Options', 'imgwize' ); ?></a>
            </h2>
                <form method="post" action="options.php" class="imgwize-form">
                <?php
                if( $active_tab == 'input_options' ) {
                settings_fields( 'imgwize_theme_input_options' );
                do_settings_sections( 'imgwize_theme_input_options' );   

                } 
                    else { 
                    settings_fields( 'imgwize_theme_social_options' );
                    do_settings_sections( 'imgwize_theme_social_options' );
                    
                } // end if/else
                    submit_button(); ?>
                </form>
</div><!-- /.wrap -->
<?php
} // end imgwize_theme_display

/* ------------------------------------------------------------------------ *
* Setting Registration
* ------------------------------------------------------------------------ */
/**
* Provides default values for the Input Options.
*/
function imgwize_theme_default_input_options() {
$defaults = array(
'imgwize_mast'   => '67',
'imgwize_header' => '',
'imgwize_intro'	 => '',
'color_option'	 => '000000'
);
return apply_filters( 'imgwize_theme_default_input_options', $defaults );
} // end imgwize_theme_default_input_options
/**
* Provides default values for the Social Options.
*/
function imgwize_theme_default_social_options() {
$defaults = array(
'twitter'	=> '',
'facebook'	=> '',
'googleplus'	=> '',
'linkedin'      => '',
);
return apply_filters( 'imgwize_theme_default_options', $defaults );
} // end imgwize_theme_default_social_options
/**
* Initializes the theme's input options by registering the Sections,
* Fields, and Settings. This particular group of options is used for
* validation and sanitization.
*
* This function is registered with the 'admin_init' hook.
*/
function imgwize_theme_initialize_input_options() {
if( false == get_option( 'imgwize_theme_input_options' ) ) {	
add_option( 'imgwize_theme_input_options', apply_filters( 'imgwize_theme_default_input_options', imgwize_theme_default_input_options() ) );
} // end if
add_settings_section(
'input_options_section',
__( 'New Header Text Options', 'imgwize' ),
'imgwize_input_options_callback',
'imgwize_theme_input_options'
);
add_settings_field(	
'imgwize_mast',	
__( 'Masthead Position', 'imgwize' ),	
'imgwize_mast_callback',	
'imgwize_theme_input_options',	
'input_options_section'	
);
add_settings_field(	
'imgwize_header',	
__( 'Header Text', 'imgwize' ),	
'imgwize_header_callback',	
'imgwize_theme_input_options',	
'input_options_section'	
);
add_settings_field(	
'imgwize_intro',	
__( 'Intro Text', 'imgwize' ),	
'imgwize_intro_callback',	
'imgwize_theme_input_options',	
'input_options_section'	
);
add_settings_field(	
'color_option',
__( 'Color of New Text', 'imgwize' ),
'imgwize_color_callback',
'imgwize_theme_input_options',
'input_options_section'
);
register_setting(
'imgwize_theme_input_options',
'imgwize_theme_input_options',
'imgwize_theme_validate_input_options'
);
} // end imgwize_theme_initialize_input_options
add_action( 'admin_init', 'imgwize_theme_initialize_input_options' );

/**
* Initializes the theme's social options by registering the Sections,
* Fields, and Settings.
*
* This function is registered with the 'admin_init' hook.
*/
function imgwize_theme_initialize_social_options() {
if( false == get_option( 'imgwize_theme_social_options' ) ) {	
add_option( 'imgwize_theme_social_options', apply_filters( 'imgwize_theme_default_social_options', imgwize_theme_default_social_options() ) );
} // end if
add_settings_section(
'social_settings_section',	// ID used to identify this section and with which to register options
__( 'Social Options', 'imgwize' ),	// Title to be displayed on the administration page
'imgwize_social_options_callback',	// Callback used to render the description of the section
'imgwize_theme_social_options'	// Page on which to add this section of options
);
add_settings_field(	
'twitter',	
__( 'Twitter', 'imgwize' ),	
'imgwize_twitter_callback',	
'imgwize_theme_social_options',	
'social_settings_section'	
);
add_settings_field(	
'facebook',	
__( 'Facebook', 'imgwize' ),	
'imgwize_facebook_callback',	
'imgwize_theme_social_options',	
'social_settings_section'	
);
add_settings_field(	
'googleplus',	
__( 'Google+', 'imgwize' ),	
'imgwize_googleplus_callback',	
'imgwize_theme_social_options',	
'social_settings_section'	
);
add_settings_field(	
'linkedin',	
__( 'LinkedIn', 'imgwize' ),	
'imgwize_linkedin_callback',	
'imgwize_theme_social_options',	
'social_settings_section'	
);
register_setting(
'imgwize_theme_social_options',
'imgwize_theme_social_options',
'imgwize_theme_sanitize_social_options'
);
} // end imgwize_theme_initialize_social_options
add_action( 'admin_init', 'imgwize_theme_initialize_social_options' );

/* ------------------------------------------------------------------------ *
* Section Callbacks
* ------------------------------------------------------------------------ */
/**
* This function provides a simple description for the Input Options page.
*
* It's called from the 'imgwize_theme_initialize_input_options_options' function by being passed as a parameter
* in the add_settings_section function.
*/
function imgwize_input_options_callback() {
echo '<p>' . __( 'Provides options to add new text to home screen.', 'imgwize' ) . '</p>';
} // end imgwize_general_options_callback

function imgwize_social_options_callback() {
echo '<p>' . __( 'Provide the URL to the social networks you\'d like to display.', 'imgwize' ) . '</p>';
echo '<p>' . __( 'Full URL with http-colon-slash-slash, etc.', 'imgwize' ) . '</p>';
} // end imgwize_general_options_callback

/* ------------------------------------------------------------------------ *
* Field Callbacks
* ------------------------------------------------------------------------ */

function imgwize_mast_callback() {
$options = get_option( 'imgwize_theme_input_options' );
if (isset ( $options['imgwize_mast'] ) ) {
$imast = esc_attr( $options['imgwize_mast'] ); }
// Render the output 
echo '<input type="number" id="imgwize_mast" name="imgwize_theme_input_options[imgwize_mast]" min="1" max="75" 
value="' . $imast . '" />';
echo '<p>' . __( 'Numeric values represent percentage of page FROM top of page', 'imgwize' ) . '</p>';
} // end imgwize_mast_callback

function imgwize_header_callback() {
$options = get_option( 'imgwize_theme_input_options' );
if (isset ( $options['imgwize_header'] ) ) {
$ihead = esc_html( $options['imgwize_header'] ); }
// Render the output 
echo '<input type="text" id="imgwize_header" name="imgwize_theme_input_options[imgwize_header]"
value="' . $ihead . '" />';
} // end imgwize_header_callback

function imgwize_intro_callback() {
$options = get_option( 'imgwize_theme_input_options' );
if (isset ( $options['imgwize_intro'] ) ) {
$iintro = esc_html( $options['imgwize_intro'] ); }
// Render the output
echo '<input type="text" id="imgwize_intro" name="imgwize_theme_input_options[imgwize_intro]" value="' . $iintro . '" />';
} // end imgwize_input_element_callback

function imgwize_color_callback() {
$options = get_option( 'imgwize_theme_input_options' );
$html = '<input  class="imgwize-color-field" type="text" id="color_option" name="imgwize_theme_input_options[color_option]" value="' . $options['color_option'] . '"/>';
$html .= '<br>';
$html .= '<label for="color_option">' . __( 'Now change the color of your new text and site-title</label>', 'imgwize' );
echo $html;
} // end imgwize_color_callback

function imgwize_twitter_callback() {
// First, we read the social options collection
$options = get_option( 'imgwize_theme_social_options' );
// Next, we need to make sure the element is defined in the options. If not, we'll set an empty string.
$url = '';
if( isset( $options['twitter'] ) ) {
$url = esc_url( $options['twitter'] );
} // end if
// Render the output
echo '<input type="text" id="twitter" name="imgwize_theme_social_options[twitter]" value="' . $url . '" />';
} // end imgwize_twitter_callback

function imgwize_facebook_callback() {
$options = get_option( 'imgwize_theme_social_options' );
$url = '';
if( isset( $options['facebook'] ) ) {
$url = esc_url( $options['facebook'] );
} // end if
// Render the output
echo '<input type="text" id="facebook" name="imgwize_theme_social_options[facebook]" value="' . $url . '" />';
} // end imgwize_facebook_callback

function imgwize_googleplus_callback() {
$options = get_option( 'imgwize_theme_social_options' );
$url = '';
if( isset( $options['googleplus'] ) ) {
$url = esc_url( $options['googleplus'] );
} // end if
// Render the output
echo '<input type="text" id="googleplus" name="imgwize_theme_social_options[googleplus]" value="' . $url . '" />';
} // end imgwize_googleplus_callback

function imgwize_linkedin_callback() {
$options = get_option( 'imgwize_theme_social_options' );
$url = '';
if( isset( $options['linkedin'] ) ) {
$url = esc_url( $options['linkedin'] );
} // end if
// Render the output
echo '<input type="text" id="linkedin" name="imgwize_theme_social_options[linkedin]" value="' . $url . '" />';
} // end imgwize_googleplus_callback

/* ------------------------------------------------------------------------ *
* Setting Callbacks
* ------------------------------------------------------------------------ */
/**
* Sanitization callback for the social options. Since each of the social options are text inputs,
* this function loops through the incoming option and strips all tags and slashes from the value
* before serializing it.
*
* @params $input The unsanitized collection of options.
*
* @returns The collection of sanitized values.
*/
function imgwize_theme_sanitize_social_options( $input ) {
	
// Define the array for the updated options
$output = array();
// Loop through each of the options sanitizing the data
foreach( $input as $key => $val ) {
if( isset ( $input[$key] ) ) {
$output[$key] = esc_url_raw( strip_tags( stripslashes( $input[$key] ) ) );
} // end if
} // end foreach
// Return the new collection
return apply_filters( 'imgwize_theme_sanitize_social_options', $output, $input );
} // end imgwize_theme_sanitize_social_options
function imgwize_theme_validate_input_options( $input ) {
// Create our array for storing the validated options
$output = array();
// Loop through each of the incoming options
foreach( $input as $key => $value ) {
// Check to see if the current option has a value. If so, process it.
if( isset( $input[$key] ) ) {
// Strip all HTML and PHP tags and properly handle quoted strings
$output[$key] = strip_tags( stripslashes( $input[ $key ] ) );
} // end if
} // end foreach
// Return the array processing any additional functions filtered by this action
return apply_filters( 'imgwize_theme_validate_input_options', $output, $input );
} // end imgwize_theme_validate_input_options

function imgwize_styles_method() {
    $options = get_option( 'imgwize_theme_input_options' );
    wp_enqueue_style(
    'imgwize-custom-style', get_template_directory_uri() . '/include/custom.css'
    ); 
    // insert background color various selectors
            $custom_css = "
                #iw-head, #iw-intro, #iw-head a, .site-title a, .site-description {
                    color: {$options['color_option']};
        }";
    wp_add_inline_style( 'imgwize-custom-style', $custom_css );
            $custom_css = "
                body.home.page #masthead, body.page #masthead {
                    margin-top: {$options['imgwize_mast']}%;
        }";
    wp_add_inline_style( 'imgwize-custom-style', $custom_css );
    }
    add_action( 'wp_enqueue_scripts', 'imgwize_styles_method' );

?>