<?php
/*
 * imgwize theme functions and definitions
 * @since 0.1
 */

function imgwize_setup() {    
    global $content_width;
    if ( !isset( $content_width  ) ) {
        $content_width  = 640;
    }

    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'post-formats', array( 'image', 'aside', 'gallery' ) );
    add_editor_style( 'custom-editor-style.css' );
    // language support - add your translation
    load_theme_textdomain('imgwize', get_template_directory() . '/languages');
    // This theme uses wp_nav_menu in one location.
    register_nav_menu( 'primary', __( 'Primary Menu', 'imgwize' ) );
    
    // custom header image support   
    $args = array(
	'width'         => 520,
	'height'        => 180,
	'default-image' => get_template_directory_uri() . '/images/default-header.png',
        'header-text'   => false,
    );
    add_theme_support( 'custom-header', $args );
    
    //Enable support for site background change
    $args = array(
	'default-color' => 'f5f5f5',
	'default-image' => get_template_directory_uri() . '/images/default-background.png',
    );
    add_theme_support( 'custom-background', $args );
}
add_action( 'after_setup_theme', 'imgwize_setup' );

    /** add ie conditional html5 shim to header
     * and additional supprt for IE9 and below browsers
     */
function imgwize_add_ie_html5_shim () {
        echo "<!--[if lt IE 9]>\n";
        echo '<script src="', get_template_directory_uri() .'/js/html5shiv.js"></script>'."\n";
        echo '<meta http-equiv="X-UA-Compatible" content="IE=9"/>'."\n";
        echo "<![endif]-->\n";
}
add_action('wp_head', 'imgwize_add_ie_html5_shim', 50);

    // Register scripts and styles
function imgwize_custom_enqueue_scripts() {
    // Register StyleSheet
    wp_enqueue_style( 'imgwize-style', get_stylesheet_uri() );

    // enable threaded comments
    if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1))
        wp_enqueue_script( 'comment-reply' );

    //* Load scripts only if custom background is being used
    if ( ! get_background_image() )
        return;
        wp_enqueue_script( 'imgwize-backstretch-min', get_stylesheet_directory_uri() . '/js/backstretch.min.js', array( 'jquery' ), '2.0.4' );
        wp_enqueue_script( 'imgwize-backstretch-set', get_stylesheet_directory_uri().'/js/backstretch-set.js' , array( 'jquery' ), '1.0.0' );
        wp_localize_script( 'imgwize-backstretch-set', 'BackStretchImg', array( 'src' => get_background_image() ) );
} 
add_action( 'wp_enqueue_scripts', 'imgwize_custom_enqueue_scripts' );

  /**
  * Filters wp_title to print a neat <title> tag based on what is being viewed.
  *
  * @param string $title Default title text for current view.
  * @param string $sep Optional separator.
  * @return string The filtered title.
  */
function imgwize_wp_title( $title, $sep ) {
         if ( is_feed() ) {
             return $title;
         }
         global $page, $paged;
          // Add the blog name
         $title .= get_bloginfo( 'name', 'display' );
          // Add the blog description for the home/front page.
         $site_description = get_bloginfo( 'description', 'display' );
         if ( $site_description && ( is_home() || is_front_page() ) ) {
             $title .= " $sep $site_description";
         }
          // Add a page number if necessary:
         if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
             $title .= " $sep " . sprintf( __( 'Page %s', '_s' ), max( $paged, $page ) );
         }
             return $title;
}
add_filter( 'wp_title', 'imgwize_wp_title', 10, 2 );

    // Add custom background callback for background color
function imgwize_custom_background_callback() {
    if ( ! get_background_color() )
        return;
        printf( '<style>body { background-color: #%s; }</style>' . "\n", get_background_color() );
}

function imgwize_widgets_init() {
    // Widgets
    register_sidebar(array(
        'name' => __('Right Sidebar', 'imgwize' ),
        'id' => 'right-sidebar',
        'description' => __('Displays to Right of Content', 'imgwize' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name' => __('Footer Center Sidebar', 'imgwize' ),
        'description' => __('Footer Widget Area in Middle', 'imgwize' ),
        'id' => 'footer-sidebar',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ));			
    register_sidebar(array(
        'name' => __('Footer Right Sidebar', 'imgwize' ),
        'description' => __('Footer Widget Area Right Side', 'imgwize' ),
        'id' => 'footer-sidebar-2',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ));			
}
add_action( 'widgets_init', 'imgwize_widgets_init' );

include_once ( get_template_directory() . '/include/theme-options.php' );

?>