<?php
/**
 * content template
 * @imgwize
 */
        if (have_posts()) : ?>		
<section id="content">
	<?php while (have_posts()) : the_post(); ?>			
	    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		    <div class="entry">
                        <header>		
		            <h2 class="entry-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
                        </header>
                            <div class="article-entry">
                                <?php the_post_thumbnail(); ?>
		                    <?php the_content(); ?>
                                        <nav class="pagination"><?php wp_link_pages(); ?></nav>
	                        <div class="postmetadata">		
                                    <div class="responses"><img alt="comments" src="<?php echo get_template_directory_uri(); ?>/images/comment.gif" height="16" width="16" /><?php comments_popup_link(); ?>   
                                    </div>			
                                        <p class="authorlinks"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"> <?php the_date(); ?></a><span><?php echo get_the_author(); ?></span> <span class="edit-link"><?php edit_post_link(__( 'Edit This', 'imgwize' )); ?></span></p>
                                            <div class="tag-link"><?php the_tags('&#9873; ', ', ', ' '); ?> </div>
                                                <div class="cat-link"><?php the_category(',') ?></div>
                                </div><!-- ends metadata -->
                            </div><!-- ends article entry -->
		    </div><!-- ends entry -->				
		        <?php comments_template(); ?>
	    </div><!-- ends id posts -->
                            <?php // show nav only for single posts' page
                                if ( is_single() ) : ?>
                            <nav class="navigation">
                                <div class="alignleft"><?php previous_posts_link(); ?></div>
                                <div class="alignright"><?php next_posts_link(); ?></div>
                            </nav> <!-- end navigation -->
                            <?php endif; ?>	
	<?php endwhile; ?>
	        
	    <?php else : ?>	
	    <div id="post-<?php the_ID(); ?>">
                <?php get_template_part( 'content', 'none' ); ?>
            </div>
</section><!-- ends #content -->	
	<?php endif; ?>
