<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Imagined
 */

?>

<div class="items col-md-6">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        
        <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
    
        <?php if ( 'post' === get_post_type() ) : ?>
        <div class="entry-meta">
            <?php imagined_posted_on(); ?>
        </div><!-- .entry-meta -->
        <?php endif; ?>
        
        <?php if(has_post_thumbnail()){ ?>
            <div class="img-container">
                <a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('imagined-featured-thumbnail'); ?></a>
            </div>
        <?php } ?>
    
        <div class="entry-summary">
            <?php the_excerpt(); ?>
            <div class="button-wrapper">
                <a href="<?php the_permalink() ?>" class="read_more"><?php _e( 'Read More', 'imagined' ); ?></a>
            </div> 
        </div><!-- .entry-summary --><div class="clearfix"></div>
        
    </article><!-- #post-## -->
</div>
