<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Imagined
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			
			<?php
            	while ( have_posts() ) : the_post();
            ?>
            <div class="header-container">
				<?php the_post_thumbnail( 'full', array( 'class' => 'header-mage' ) ); ?>
                <header class="entry-header">
                    
                    <div class="container">
                        <div class="post-details">
                            <?php
                                if ( is_single() ) {
                                    the_title( '<h1 class="entry-title">', '</h1>' );
                                } else {
                                    the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                }
                            if ( 'post' === get_post_type() ) : ?>
                            <div class="entry-meta">
                                <?php imagined_posted_on(); ?>
                            </div><!-- .entry-meta -->
                            <?php
                            endif; ?>
                        </div>
                    </div>
                    
                    <div class="black-overlay"></div>
                </header><!-- .entry-header -->
            </div>    
                <div class="container">
                    <div class="row">
                    	<div class="col-md-12">
							<?php
                    
                                get_template_part( 'template-parts/content', 'single' );
                    
                                the_post_navigation();
                    
                                // If comments are open or we have at least one comment, load up the comment template.
                                if ( comments_open() || get_comments_number() ) :
                                    comments_template();
                                endif;
                    
                                endwhile; // End of the loop.
                            ?>
                    </div>
				</div>
            </div>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php

get_footer();
