<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Imagined
 */

get_header(); ?>

	<section id="primary" class="content-area">
    <main id="main" class="site-main" role="main">
        <div class="header-container">
			<?php
                $img = wp_get_attachment_image_src(get_post_thumbnail_id(get_option('page_for_posts')),'full'); 
                $featured_image = $img[0];
				if($featured_image){
					echo '<img src="'. $featured_image .'" class="header-mage" />';
				}
            ?>
            
            <header class="entry-header" >
                <?php if ( is_home() ) { ?>
					<h1 class="entry-title"><?php _e('Blog Page', 'imagined') ?></h1><?php
				}else{
					the_title( '<h1 class="entry-title">', '</h1>' ); 
				}?>
                <div class="black-overlay"></div>
            </header><!-- .entry-header -->
        </div>    
        <div class="container">
            <div class="blog-template post-wrapper">
                <div class="row">
                    <div id="manson">
                        <?php
                        if ( have_posts() ) : ?>
                
                            <?php
                            /* Start the Loop */
                            while ( have_posts() ) : the_post();
                
                                /**
                                 * Run the loop for the search to output the results.
                                 * If you want to overload this in a child theme then include a file
                                 * called content-search.php and that will be used instead.
                                 */
                                get_template_part( 'template-parts/content', get_post_format() );
                
                            endwhile;
                
                           
                        else :
                
                            get_template_part( 'template-parts/content', 'none' );
                
                        endif; ?>
                        <?php the_posts_pagination( array(
							'mid_size' => 2,
							'prev_text' => '<span class="fa fa-chevron-left"></span>',  
			  				'next_text' => '<span class="fa fa-chevron-right"></span>'
						) ); 
						?>
                            
                  
                </div><!--manson-->
            </div>
        </div>
    </main><!-- #main -->
</section><!-- #primary -->

<?php
get_footer();
