<?php
/**
 * Photog Theme Customizer.
 *
 * @package Imagined
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function imagined_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	
	/* Heder Pannel */
	$wp_customize->add_panel( 'imagined_header_option_panel', array(
		'priority'       => 21,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '',
		'title'          => __( 'Header Options', 'imagined' ),
		'description'    => __( 'Header Option Panel', 'imagined' ),
	) );
	
	
	$wp_customize->add_section( 'imagined_search_icon_section' , array(
		'title'       => __( 'Search Option', 'imagined' ),
		'priority'    => 22,
		'description' => __( 'Search Option', 'imagined' ),
		'panel'	=> 'imagined_header_option_panel'
	) );
	
	$wp_customize->add_setting('imagined_display_search_icon_setting', array(
		'default'        => 0,
		'sanitize_callback' => 'imagined_sanitize_checkbox',
	));
	
	$wp_customize->add_control('imagined_display_search_icon_control', array(
		'settings' => 'imagined_display_search_icon_setting',
		'label'    => __('Show Search Icon', 'imagined'),
		'section'  => 'imagined_search_icon_section',
		'type'     => 'checkbox',
		'priority'	=> 3
	));
	
	//slider
	$wp_customize->add_section( 'imagined_slider_section' , array(
		'title'       => __( 'Slider', 'imagined' ),
		'priority'    => 21,
		'description' => __( 'Slider Option', 'imagined' ),
		
	) );

	//  Set Speed
	$wp_customize->add_setting( 'imagined_slider_speed_setting', array (
		'default' => '6000',
		'sanitize_callback' => 'imagined_sanitize_integer',
	) );
	
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_slider_speed', array(
		'label'    => __( 'Slider Speed (milliseconds)', 'imagined' ),
		'section'  => 'imagined_slider_section',
		'settings' => 'imagined_slider_speed_setting',
		'priority'	=> 24
	) ) );
	
	$categories = get_categories();
			$cats = array();
			$i = 0;
			foreach($categories as $category){
				if($i==0){
					$default = $category->slug;
					$i++;
				}
				$cats[$category->slug] = $category->name;
			}
	
	//  =============================
	//  Select Box               
	//  =============================
	$wp_customize->add_setting('imagined_slider_category_setting', array(
		'default' => '',
		'sanitize_callback' => 'imagined_sanitize_category',
	));

	$wp_customize->add_control('imagined_slider_category_control', array(
		'settings' => 'imagined_slider_category_setting',
		'type' => 'select',
		'label' => __( 'Select Category:', 'imagined' ),
		'section' => 'imagined_slider_section',
		'choices' => $cats,
		'priority'	=> 24
	));
	
	/* social media option */
	$wp_customize->add_section( 'imagined_social_section' , array(
		'title'       => __( 'Social Media Icons', 'imagined' ),
		'priority'    => 20,
		'description' => __( 'Optional social media buttons in the header', 'imagined' ),
		'panel'	=> 'imagined_header_option_panel'
	) );

	$wp_customize->add_setting( 'imagined_facebook_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_facebook', array(
		'label'    => __( 'Enter your Facebook url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_facebook_setting',
		'priority'    => 1,
	) ) );

	$wp_customize->add_setting( 'imagined_twitter_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );
	
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_twitter', array(
		'label'    => __( 'Enter your Twitter url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_twitter_setting',
		'priority'    => 2,
	) ) );
	
	$wp_customize->add_setting( 'imagined_google_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );
	
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_google', array(
		'label'    => __( 'Enter your Google+ url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_google_setting',
		'priority'    => 3,
	) ) );

	$wp_customize->add_setting( 'imagined_pinterest_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_pinterest', array(
		'label'    => __( 'Enter your Pinterest url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_pinterest_setting',
		'priority'    => 4,
	) ) );

	$wp_customize->add_setting( 'imagined_linkedin_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_linkedin', array(
		'label'    => __( 'Enter your Linkedin url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_linkedin_setting',
		'priority'    => 5,
	) ) );

	$wp_customize->add_setting( 'imagined_youtube_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_youtube', array(
		'label'    => __( 'Enter your Youtube url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_youtube_setting',
		'priority'    => 6,
	) ) );

	$wp_customize->add_setting( 'imagined_tumblr_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_tumblr', array(
		'label'    => __( 'Enter your Tumblr url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_tumblr_setting',
		'priority'    => 7,
	) ) );

	$wp_customize->add_setting( 'imagined_instagram_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_instagram', array(
		'label'    => __( 'Enter your Instagram url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_instagram_setting',
		'priority'    => 8,
	) ) );

	$wp_customize->add_setting( 'imagined_flickr_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_flickr', array(
		'label'    => __( 'Enter your Flickr url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_flickr_setting',
		'priority'    => 9,
	) ) );

	$wp_customize->add_setting( 'imagined_vimeo_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_vimeo', array(
		'label'    => __( 'Enter your Vimeo url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_vimeo_setting',
		'priority'    => 1,
	) ) );
	$wp_customize->add_setting( 'imagined_rss_setting', array (
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'imagined_rss', array(
		'label'    => __( 'Enter your RSS url', 'imagined' ),
		'section'  => 'imagined_social_section',
		'settings' => 'imagined_rss_setting',
		'priority'    => 11,
	) ) );
	
	/* color option */
	$wp_customize->add_setting( 'imagined_primary_color_setting', array (
		'default'     => '#111111',
		'sanitize_callback' => 'sanitize_hex_color',
	) );
	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'imagined_primary_color', array(
			'label'    => __( 'Theme Primary Color', 'imagined' ),
			'section'  => 'colors',
			'settings' => 'imagined_primary_color_setting',
	) ) );

}
add_action( 'customize_register', 'imagined_customize_register' );

/**
 * Sanitize integer input
 */
if ( ! function_exists( 'imagined_sanitize_integer' ) ) :
	function imagined_sanitize_integer( $input ) {		
		return absint($input);
	}
endif;

/**
 * Sanitize checkbox
 */

if (!function_exists( 'imagined_sanitize_checkbox' ) ) :
	function imagined_sanitize_checkbox( $input ) {
		if ( $input != 1 ) {
			return 0;
		} else {
			return 1;
		}
	}
endif;

if ( ! function_exists( 'imagined_sanitize_category' ) ){
	function imagined_sanitize_category( $input ) {
		$categories = get_categories();
		$cats = array();
		$i = 0;
		foreach($categories as $category){
			if($i==0){
				$default = $category->slug;
				$i++;
			}
			$cats[$category->slug] = $category->name;
		}
		$valid = $cats;

		if ( array_key_exists( $input, $valid ) ) {
			return $input;
		} else {
			return '';

		}
	}
}

/**
* Apply Color Scheme
*/
if ( ! function_exists( 'imagined_apply_color' ) ) :
  function imagined_apply_color() {
	?>
	<style id="color-settings">
  <?php if (esc_html(get_theme_mod('imagined_primary_color_setting') )) { ?>
		 .header-wrapper, .site-side-bar, .footer-widget-container, .search-form-container, .serch-form-coantainer input[type="submit"], .footer-widget input[type="submit"], button, input[type="button"], input[type="reset"], input[type="submit"]{background:<?php echo esc_html(get_theme_mod('imagined_primary_color_setting')); ?>}
	<?php } ?>
	
	</style>
	<?php	  
  }
endif;
add_action( 'wp_head', 'imagined_apply_color' );


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function imagined_customize_preview_js() {
	wp_enqueue_script( 'imagined_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'imagined_customize_preview_js' );
