<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Imagined
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#main"><?php esc_html_e( 'Skip to content', 'imagined' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
    	            
    	<div class="header-wrapper">
        	<div class="inner-wrapper">
                <div class="container">
                	
                    <div class="site-branding">
                    	
                        <?php if ( function_exists( 'the_custom_logo' ) ) { ?>
                        	<div class="site-logo">
								<?php the_custom_logo(); ?>
							</div>
						<?php } ?>
                            <h1 class="site-title site-logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                                    
                    </div><!-- .site-branding -->
                    
                    <div id="mobile-icon" class="mobile-icon">
                        <ul class="social-meidia">
                            <?php if ( get_theme_mod( 'imagined_facebook_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_facebook_setting' ) ); ?>" title="<?php esc_attr_e('Facebook', 'imagined'); ?>"><i class="fa fa-facebook"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_twitter_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_twitter_setting' ) ); ?>" title="<?php esc_attr_e('Twitter', 'imagined'); ?>"><i class="fa fa-twitter"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_google_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_google_setting' ) ); ?>" title="<?php esc_attr_e('Google Plus', 'imagined'); ?>"><i class="fa fa-google-plus"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_pinterest_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_pinterest_setting' ) ); ?>" title="<?php esc_attr_e('Pinterest', 'imagined'); ?>"><i class="fa fa-pinterest"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_linkedin_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_linkedin_setting' ) ); ?>" title="<?php esc_attr_e('Linkedin', 'imagined'); ?>"><i class="fa fa-linkedin"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_youtube_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_youtube_setting' ) ); ?>" title="<?php esc_attr_e('Youtube', 'imagined'); ?>"><i class="fa fa-youtube"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_tumblr_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_tumblr_setting' ) ); ?>" title="<?php esc_attr_e('Tumbler', 'imagined'); ?>"><i class="fa fa-tumblr"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_instagram_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_instagram_setting' ) ); ?>" title="<?php esc_attr_e('Instagram', 'imagined'); ?>"><i class="fa fa-instagram"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_flickr_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_flickr_setting' ) ); ?>" title="<?php esc_attr_e('Flicker', 'imagined'); ?>"><i class="fa fa-flickr"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_vimeo_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_vimeo_setting' ) ); ?>" title="<?php esc_attr_e('Vimeo', 'imagined'); ?>"><i class="fa fa-vimeo-square"></i></a></li>
                            <?php } ?>
                            <?php if ( get_theme_mod( 'imagined_rss_setting' ) ){ ?>
                                <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_rss_setting' ) ); ?>" title="<?php esc_attr_e('RSS', 'imagined'); ?>"><i class="fa fa-rss"></i></a></li>
                            <?php } ?> 
                            <?php $search_display = get_theme_mod( 'imagined_display_search_icon_setting', 0); ?>
                            <?php if($search_display == 1){ ?> 
                                <li>
                                    <div class="search-icon-wrapper">
                                        <span id="search-icon"><i class="fa fa-search"></i></span>
                                    </div>
                                </li>  
                            <?php } ?>              
                        </ul>
                    </div>
                    
                    <div class="nav-wrapper">
                        <i id="site-nav" class="fa fa-bars"></i>
                    </div>
                    
                    <div id="show-icons">
                        <i class="fa fa-angle-down"></i>
                        <i class="fa fa-angle-up hide-icons"></i>
                    </div>
                </div>
            
                <div class="search-form-container">
                    <div class="container">
                        <div class="serch-form-coantainer">
                        	<?php get_search_form(); ?>
                            <i class="fa fa-times close-bar" aria-hidden="true"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--header-wrapper-->
        
	</header><!-- #masthead -->
    
	<div id="slide-bar" class="site-side-bar hide-bar ">
        <i class="fa fa-times close-bar" aria-hidden="true"></i>
        <?php get_sidebar(); ?>
		<?php if(is_front_page() || is_home()){
				$theme = wp_get_theme();
			?> 
        	<asside class="site-copyright hide-bar">
                <?php _e('Powered by ', 'imagined'); ?><a href="<?php echo esc_url( 'http://wordpress.org/'  ); ?>" title="<?php esc_attr_e( 'WordPress' ,'imagined' ); ?>"><?php _e('WordPress' ,'imagined'); ?></a>
                <?php _e(' and ', 'imagined'); ?><a href="<?php echo esc_url( $theme->get( 'AuthorURI' ) ); ?>"><?php _e('Electric WP', 'imagined'); ?></a>
        	</asside>
		<?php } ?>
    </div>
    
	<div id="content" class="site-content">
        <div class="container">
            <?php if ( has_header_image() ) { ?>
                <div class="img-header">
                    <img src="<?php header_image(); ?>" height="<?php echo esc_attr(get_custom_header()->height); ?>" width="<?php echo esc_attr(get_custom_header()->width); ?>" alt="" />
                </div>
            <?php } ?>
        </div>
