<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Imagined
 */

?>

	</div><!-- #content -->
	<div class="footer-space"></div>
	<div class="footer-widget-container">
        <div class="container">
            <div class="row">
                <div class="col-md-4">                    
                    <?php dynamic_sidebar('imagined-footer-one-widget'); ?>
                </div>
                <div class="col-md-4">                    
                    <?php dynamic_sidebar('imagined-footer-two-widget'); ?>
                </div>
                <div class="col-md-4">                    
                    <?php dynamic_sidebar('imagined-footer-three-widget'); ?>
                </div>
            </div>
        </div>
    </div>
    
	<footer id="colophon" class="site-footer" role="contentinfo">
    	<div class="container">
            
            <div class="footer-social-media">
            	<ul class="social-meidia">
                    <?php if ( get_theme_mod( 'imagined_facebook_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_facebook_setting' ) ); ?>" title="<?php esc_attr_e('Facebook', 'imagined'); ?>"><i class="fa fa-facebook"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_twitter_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_twitter_setting' ) ); ?>" title="<?php esc_attr_e('Twitter', 'imagined'); ?>"><i class="fa fa-twitter"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_google_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_google_setting' ) ); ?>" title="<?php esc_attr_e('Google Plus', 'imagined'); ?>"><i class="fa fa-google-plus"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_pinterest_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_pinterest_setting' ) ); ?>" title="<?php esc_attr_e('Pinterest', 'imagined'); ?>"><i class="fa fa-pinterest"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_linkedin_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_linkedin_setting' ) ); ?>" title="<?php esc_attr_e('Linkedin', 'imagined'); ?>"><i class="fa fa-linkedin"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_youtube_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_youtube_setting' ) ); ?>" title="<?php esc_attr_e('Youtube', 'imagined'); ?>"><i class="fa fa-youtube"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_tumblr_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_tumblr_setting' ) ); ?>" title="<?php esc_attr_e('Tumbler', 'imagined'); ?>"><i class="fa fa-tumblr"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_instagram_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_instagram_setting' ) ); ?>" title="<?php esc_attr_e('Instagram', 'imagined'); ?>"><i class="fa fa-instagram"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_flickr_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_flickr_setting' ) ); ?>" title="<?php esc_attr_e('Flicker', 'imagined'); ?>"><i class="fa fa-flickr"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_vimeo_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_vimeo_setting' ) ); ?>" title="<?php esc_attr_e('Vimeo', 'imagined'); ?>"><i class="fa fa-vimeo-square"></i></a></li>
                    <?php } ?>
                    <?php if ( get_theme_mod( 'imagined_rss_setting' ) ){ ?>
                        <li><a href="<?php echo esc_url( get_theme_mod( 'imagined_rss_setting' ) ); ?>" title="<?php esc_attr_e('RSS', 'imagined'); ?>"><i class="fa fa-rss"></i></a></li>
                    <?php } ?>  
                </ul>
            </div>
            
            <div class="site-info">
                <?php if(!is_home()){  
                    echo '&copy; ' . esc_attr( get_bloginfo( 'name' ) ); 	
                }?>
            </div><!-- .site-info -->
            
        </div>
	</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
