<?php
/**
 * Template for displaying search results.
 *
 * @package Illuminate
 */

get_header(); ?>

<main id="content" class="row" role="main">
	<div class="small-12 columns">
		<div class="panel">
			<div class="row">
				<div class="small-12 medium-8 columns">
					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'content', 'search' ); ?>
						<?php endwhile; ?>
						
						<?php illuminate_paging_nav(); ?>
					<?php else : ?>
						<header class="page-header">
							<h1 class="page-title"><?php printf( __( 'No Results', 'illuminate' ) ); ?></h1>
						</header>
						
						<p><?php printf( __( 'Sorry, but we didn&rsquo;t find any posts that matched your search terms. Please try some different keywords.', 'illuminate' ) ); ?></p>
					<?php endif; ?>
				</div>
				
				<div class="small-12 medium-4 columns">
					<?php get_sidebar(); ?>
				</div>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>