<?php
/**
 * Custom template tags that could be used for all of my themes.
 *
 * @package Illuminate
 */

// Displays header entry meta: sticky status, date/time of post, author
if ( ! function_exists( 'illuminate_header_meta' ) ) :
function illuminate_header_meta() {
	global $post; 
	?>
	
	<p class="entry-meta">
		<?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
			<span class="sticky">Sticky</span>
		<?php endif; ?>
		
		<span class="date"></span><a href="<?php the_permalink(); ?>" rel="bookmark"><time datetime="<?php echo get_the_date( 'c' ); ?>"><?php echo esc_html( get_the_date() ); ?></time></a>
			
		<span class="author"></span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) );?>" rel="bookmark"><?php the_author(); ?></a>
	</p>
<?php } endif;

// Displays footer entry meta: categories, tags, and edit link if the user is logged in
if ( ! function_exists( 'illuminate_footer_meta' ) ) :
function illuminate_footer_meta() { ?>
	<p class="entry-meta">
		<?php
		$categories = get_the_category_list( ', ' );
		if ( $categories ) :
			printf( '<span class="category">%1$s</span>', $categories );
		else :
			printf( '<span class="category">%1$s</span>', __( 'Not Categorized', 'illuminate' ) );
		endif;
		?>
		
		<?php
		$tags = get_the_tag_list( null, ', ' );
		if ( $tags ) :
			printf( '<span class="tag">%1$s</span>', $tags );
		else :
			printf( '<span class="tag">%1$s</span>', __( 'Not Tagged', 'illuminate' ) );
		endif;
		
		// Don't display comments link on single pages
		if ( ! is_single() ) :
			if ( ! comments_open() && 0 == get_comments_number() ) : ?>
				<span class="comment"><?php _e( 'Comments are closed', 'illuminate' ); ?></span>
			<?php else : ?>
				<span class="comment"><?php comments_popup_link( __( 'Leave a comment', 'illuminate' ), __( '1 Comment', 'illuminate' ), __( '% Comments', 'illuminate' ), null, null ); ?></span>
			<?php endif;
		endif;
		
		edit_post_link( __( 'Edit', 'illuminate' ), '<span class="edit-link">', '</span>' ); ?>
	</p>
<?php } endif;

// Custom function to display comments
if ( ! function_exists( 'illuminate_show_comments' ) ) :
function illuminate_show_comments( $comment, $args, $depth ) {
	$GLOBALS[ 'comment' ] = $comment;
	global $post;
	
	if ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) : ?>

		<li id="pingback-<?php comment_ID(); ?>" <?php comment_class(); ?> >
			<?php _e( 'Pingback:', 'illuminate' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( 'Edit', 'illuminate' ), '<i class="genericon genericon-edit"> </i>', null, null ); ?>
		</li>

	<?php else : ?>

		<li id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?> >
			<article id="comment-<?php comment_ID(); ?>" class="row">
				<header class="comment-header">
						<?php if ( 0 != $args[ 'avatar_size' ] ) :
							echo get_avatar( $comment, $args[ 'avatar_size' ] );
						endif; ?>
						
						<?php printf( __( '%s <span class="says">says:</span>', 'illuminate' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) );
						
						// If the comment author is also the post author, put a note to that effect.
						if ( $comment->user_id == $post->post_author ) :
							printf( ' <span class="label radius">%s</span> ', __( 'Post Author', 'illuminate' ) );
						endif;
						?>
						
					<p class="comment-meta"
						<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
							<time datetime="<?php comment_time( 'c' ); ?>"><?php printf( _x( '%1$s at %2$s', 'date, time', 'illuminate' ), get_comment_date(), get_comment_time() ); ?></time>
						</a>
						<?php edit_comment_link( __( 'Edit', 'illuminate' ), '<i class="genericon genericon-edit"> </i> ', null, null ); ?>
					</p>
						
					<?php if ( '0' == $comment->comment_approved ) : ?>
						<p class="alert round label"><?php _e( 'Your comment is awaiting moderation.', 'illuminate' ); ?></p>
					<?php endif; ?>
				
				</header>

					<?php comment_text(); ?>
				
					<?php
					// Display the comment reply link
					comment_reply_link( array_merge( $args, array(
						'add_below' => 'div-comment',
						'depth'     => $depth,
						'max_depth' => $args['max_depth'],
						'before'    => '<p>',
						'after'     => '</p>',
					) ) );
					?>
			</article><!-- .comment-body -->
		</li>

	<?php endif; // ends check for pingback or regular comment
} endif; // ends check for illuminate_show_comments()

// Displays page navigation
if ( ! function_exists( 'illuminate_paging_nav' ) ):
function illuminate_paging_nav() {
	// Don't print anything if there's only one page
	if ( $GLOBALS[ 'wp_query' ]->max_num_pages < 2 ) {
		return;
	} ?>
	
	<nav class="paging-navigation row" role="navigation">
		<h2 class="screen-reader-text"><?php _e( 'Posts navigation', 'illuminate' ); ?></h2>
		<div class="small-6 columns">
			<?php if ( get_next_posts_link() ) : ?>
				<div class="nav-previous"><?php next_posts_link( __( '&laquo; Older Posts', 'illuminate' ) ); ?></div>
			<?php endif; ?>
		</div>
		
		<div class="small-6 columns">
			<?php if ( get_previous_posts_link() ) : ?>
				<div class="nav-next"><?php previous_posts_link( __( 'Newer Posts &raquo;', 'illuminate' ) ); ?></div>
			<?php endif; ?>
		</div>
	</nav>
<?php } endif;

// Displays navigation between single posts (called by single.php)
if ( ! function_exists( 'illuminate_post_nav' ) ) :
function illuminate_post_nav() {
	// Don't print anything if there's nothing to navigate to
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );
	
	if ( ! $next && ! $previous ) {
		return;
	} ?>
	
	<nav class="post-navigation row" role="navigation">
		<h2 class="screen-reader-text"><?php _e( 'Post navigation', 'illuminate' ); ?></h2>
		<div class="small-6 columns">
			<div class="nav-previous"><?php previous_post_link( '%link', '&laquo; %title', null, null ); ?></div>
		</div>
		
		<div class="small-6 columns">
			<div class="nav-next"><?php next_post_link( '%link', '%title &raquo;', null, null ); ?></div>
		</div>
	</nav>
<?php } endif;
	
function illuminate_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'all_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'all_the_cool_cats', $all_the_cool_cats );
	}

	if ( '1' != $all_the_cool_cats ) {
		// This blog has more than 1 category so drizzle_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so drizzle_categorized_blog should return false.
		return false;
	}
}

// Flush transients from illuminate_categorized_blog()
function illuminate_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'all_the_cool_cats' );
}
add_action( 'edit_category', 'illuminate_category_transient_flusher' );
add_action( 'save_post', 'illuminate_category_transient_flusher' ); ?>