<?php
/**
 * Contains various meta information and also the site title, description, and main navigation menu
 *
 * @package Illuminate
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
        <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> >

<header id="masthead" class="row" role="banner">
	<div class="small-12 columns">
		<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
		<p class="site-description"><?php bloginfo( 'description' ); ?></p>
		
		<nav id="site-navigation" class="main-navigation row" role="navigation">
			<div class="small-12 columns">
				<div class="panel callout">
					<div class="row">
						<div class="small-12 medium-4 medium-push-8 columns">
							<?php get_search_form(); ?>
						</div>
						
						<div class="small-12 medium-8 medium-pull-4 columns">
							<h1 class="menu-toggle"><?php _e( 'Menu', 'illuminate' ); ?></h1>
							<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to Content', 'illuminate' ); ?></a>
			
							<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
						</div>
					</div>
				</div>
			</div>
		</nav>	
	</div>
</header>