<?php
/**
 * Displays individual blog posts. Called in The Loop(tm) in index.php
 *
 * @package Illuminate
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'row' ); ?> >
	<div class="small-12 columns">
		<header class="entry-header">
			<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>	
			<?php illuminate_header_meta(); ?>
		</header>
		
		<!-- Display featured image, if one exists -->
		<div class="row">
			<?php if ( has_post_thumbnail() ) : ?>
				<div class="small-12 medium-4 columns">
					<?php
					echo wp_get_attachment_link( get_post_thumbnail_id(), 'full', true, false, false );
					?>
				</div>
				
				<div class="small-12 medium-8 columns">
			<?php else : ?>
				<div class="small-12 columns">
			<?php endif; ?>
					<?php the_content(); ?>
				</div>
		</div>

		<div class="pagination-centered">
			<?php 
			// I set up a custom function in functions.php to use Foundation's pagination.
			wp_link_pages();
			?>
		</div>
				
		<footer class="entry-footer">
			<?php illuminate_footer_meta(); ?>
		</footer>
	</div>
</article>