<?php
/**
 * Displays a static page. Called via page.php
 *
 * @package Illuminate
 */
?>

<article id="page-<?php the_ID(); ?>" <?php post_class( 'row' ); ?> >
	<div class="small-12 columns">
		<header class="entry-header">
			<h1 class="entry-title"><?php the_title(); ?></h1>
			<p class="entry-meta">
				<span class="author"></span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) );?>" rel="bookmark"><?php the_author(); ?></a>
				<?php edit_post_link( __( 'Edit', 'illuminate' ), '<span class="edit-link">', '</span>' ); ?>
			</p>
		</header>
		
		<?php the_content(); ?>
		
		<div class="pagination-centered">
			<?php 
			// I set up a custom function in functions.php to use Foundation's pagination.
			wp_link_pages();
			?>
		</div>
	</div>
</article>