<?php
/**
 * Displays image attachments. Called in The Loop(tm) in image.php
 *
 * @package Illuminate
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'row' ); ?> >
	<div class="small-12 columns">
		<header class="entry-header">
			<h1 class="entry-title"><?php the_title(); ?></h1>
			<p class="entry-meta">
				<span class="attached"><?php printf( __( 'Attached to <a href="%1$s">%2$s</a>', 'illuminate' ), get_permalink( $post->post_parent ), get_the_title( $post->post_parent ) ); ?></span>
				
				<span class="author"></span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) );?>" rel="bookmark"><?php the_author(); ?></a>
				
				<?php if ( wp_attachment_is_image() && 'attachment' == $post->post_type ) :
					$attachment_metadata = wp_get_attachment_metadata( $post->ID ); ?>
					<span class="zoom"><a href="<?php echo esc_html( wp_get_attachment_url( $post->ID ) ); ?>"><?php printf( __( 'See full-size image: (%1$s x %2$s)', 'illuminate' ), $attachment_metadata[ 'height' ], $attachment_metadata[ 'width' ] ); ?></a></span>
				<?php endif; ?>
				
				<?php edit_post_link( __( 'Edit', 'illuminate' ), '<span class="edit-link">', '</span>' ); ?>
			</p>
		</header>
		
		<a href="<?php echo esc_html( wp_get_attachment_url( $post->ID ) ); ?>">
			<?php echo wp_get_attachment_image( $post->ID, 'full' ); ?>
		</a>
		
		<?php the_content(); ?>
	</div>
</article>