<?php
/**
 * Template for displaying comments and also for displaying the comment form.
 * The comments are actually displayed by a callback to illuminate_show_comments(), defined
 * in the inc/template-tags.php file.
 *
 * @package Illuminate
 */

// If the post is password protected, return early (unless the visitor entered the password).
if ( post_password_required() ) {
	return;
}
?>
<section id="comments" class="row">
	<div class="small-12 columns">
		<?php if ( have_comments() ) : ?>
			<h2 class="comments-area-title">
				<?php
				printf( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'illuminate' ), number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
				?>
			</h2>
			
			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
				<nav id="comment-nav-above" class="row comment-navigation" role="navigation">
					<h3 class="screen-reader-text"><?php _e( 'Comment navigation', 'illuminate' ); ?></h3>
					<div class="small-6 columns">
						<div class="nav-previous"><?php previous_comments_link( __( '&larr; Previous Comments', 'illuminate' ) ); ?></div>
					</div>
					
					<div class="small-6 columns">
						<div class="nav-next"><?php next_comments_link( __( 'Next Comments &rarr;', 'illuminate' ) ); ?></div>
					</div>
				</nav>
			<?php endif; ?>
			
			<ol class="comment-list">
				<?php
				$comment_args = array(
					'callback' => 'illuminate_show_comments'
				);
				wp_list_comments( $comment_args );
				?>
			</ol>
			
			<?php
			// Provide comment navigation both above and below the list of comments. This is nice because a full page of comments gets long quickly.
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
			?>
				<nav id="comment-nav-below" class="row comment-navigation" role="navigation">
					<h3 class="screen-reader-text"><?php _e( 'Comment navigation', 'illuminate' ); ?></h3>
					<div class="small-6 medium-6 columns">
						<div class="nav-previous"><?php previous_comments_link( __( '&larr; Previous Comments', 'illuminate' ) ); ?></div>
					</div>
					
					<div class="small-6 medium-6 columns">
						<div class="nav-next"><?php next_comments_link( __( 'Next Comments &rarr;', 'illuminate' ) ); ?></div>
					</div>
				</nav>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php
		// If comments are closed, leave a note. This has to come after the check for comments because we want to display comments if there were any prior to comments being closed.
		if ( ! comments_open() && post_type_supports( get_post_type(), 'comments' ) && ! is_page() ) :
		?>
			<p><span class="label radius"><?php _e( 'Comments are closed.', 'illuminate' ); ?></span></p>
		<?php endif; ?>
		
		<?php
		$form_args = array(
			'id_submit' => 'foundation-submit'
		);
		
		comment_form( $form_args );
		?>
	</div>
</section>