<?php
/**
 * Template for displaying image attachments
 *
 * @package Illuminate
 */
 
get_header(); ?>

<main id="content" class="row" role="main">
	<div class="small-12 columns">
		<div class="panel">
			<div class="row">
				<div class="small-12 medium-8 columns">
					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'content', 'attachment' ); ?>
						<?php endwhile; ?>
					<?php endif; ?>
					
					<nav class="attachment-navigation row" role="navigation">
						<h2 class="screen-reader-text"><?php _e( 'Gallery navigation', 'illuminate' ); ?></h2>
						<div class="small-6 columns">
								<div class="nav-previous"><?php previous_image_link( 'fullsize', __( '&laquo; Previous Image', 'illuminate' ) ); ?></div>
						</div>
		
						<div class="small-6 columns">
								<div class="nav-next"><?php next_image_link( 'fullsize', __( 'Next Image &raquo;', 'illuminate' ) ); ?></div>
						</div>
					</nav>
					
					<?php comments_template(); ?>
				</div>
				
				<div class="small-12 medium-4 columns">
					<?php get_sidebar(); ?>
				</div>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>