<?php
/**
 * Displays archives: category, author, date, etc.
 *
 * @package Illuminate
 */
 
get_header(); ?>

<main id="main" class="row" role="main">
	<div class="small-12 columns">
		<div class="panel">
			<div class="row">
				<div class="small-12 medium-8 columns">
					<?php if ( have_posts() ) : ?>
						<header class="page-header">
							<h1 class="page-title">
								<?php
								if ( is_category() ) :
									printf( __( 'Browsing the &ldquo;%1$s&rdquo; category', 'illuminate' ), single_cat_title( null, false ) );
							
								elseif ( is_tag() ) :
									printf( __( 'Browsing the &ldquo;%1$s&rdquo; tag', 'illuminate' ), single_tag_title( null, false ) );
							
								elseif ( is_author() ) :
									// We call the first post so we know who the author is
									the_post();
									printf( __( 'Browsing %1$s&lsquo;s posts', 'illuminate' ), get_the_author() );
							
									// We have to rewind The Loop(tm) because we called the_post()
									rewind_posts();
							
								elseif ( is_day() ) :
									printf( __( 'Browsing posts made on %1$s', 'illuminate' ), get_the_date() );
							
								elseif ( is_month() ) :
									printf( __( 'Browsing posts made in %1$s', 'illuminate' ), get_the_date( 'F, Y' ) );
							
								elseif ( is_year() ) :
									printf( __( 'Browsing posts made in %1$s', 'illuminate' ), get_the_date( 'Y' ) );
							
								elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
									_e( 'Asides', 'illuminate' );

								elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
									_e( 'Images', 'illuminate');

								elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
									_e( 'Videos', 'illuminate' );

								elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
									_e( 'Quotes', 'illuminate' );

								elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
									_e( 'Links', 'illuminate' );

								else :
									_e( 'Archives', 'illuminate' );

								endif;
								?>
							</h1>
						</header>
				
						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'content', get_post_format() ); ?>
						<?php endwhile; ?>
				
						<?php illuminate_paging_nav(); ?>
					<?php else : ?>
						<header class="page-header">
							<h1 class="page-title">
								<?php printf( __( 'No Results', 'illuminate' ) ); ?>
							</h1>
						</header>
				
						<p><?php printf( __( 'Sorry, but we didn&rsquo;t find any posts that matched your search terms. Please try some different keywords.', 'illuminate' ) ); ?></p>
				
					<?php endif; ?>
				</div>
				
				<div class="small-12 medium-4 columns">
					<?php get_sidebar(); ?>
				</div>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>			