<?php
/**
 * Template for displaying a 404 page
 *
 * @package Illuminate
 */

get_header(); ?>

<main id="content" class="row" role="main">
	<div class="small-12 columns">
		<div class="panel">
			<div class="row">
				<div class="small-12 columns">
					<header>
						<h1 class="page-header"><?php printf( __( 'Page Not Found', 'illuminate' ) ); ?></h1>
					</header>
					
					<p><?php printf( __( 'Oops! We can&rsquo;t find that page. Try searching or checking one of the links below.', 'illuminate' ) ); ?></p>
					
					<section id="404-widgets" class="widget-area row" role="complementary">
						<header>
							<h1 class="screen-reader-text">404 Widgets</h1>
						</header>
						
						<?php
						$widget_args = array(
							'before_title' => '<h2 class="widget-title">',
							'after_title'  => '</h2>'
						);
						
						// This blog has more than one category
						if ( illuminate_categorized_blog() ) : ?>
							<div class="small-12 medium-6 columns">
								<div class="widget widget_categories">
									<h2><?php _e( 'Most Used Categories', 'illuminate' ); ?></h2>
									<ul>
										<?php
										wp_list_categories( array(
											'orderby'    => 'count',
											'order'      => 'DESC',
											'show_count' => 1,
											'title_li'   => '',
											'number'     => 10
										) );
										?>
									</ul>
								</div>
							</div>
							
							<div class="small-12 medium-6 columns">
								<div class="widget widget_posts">
									<?php the_widget( 'WP_Widget_Recent_Posts', null, $widget_args ); ?>
								</div>
							</div>
						<?php
						// This blog has only one category, so just show one large recent posts widget
						else : ?>
							<div class="small-12 medium-6 columns">
								<div class="widget widget_posts">
									<?php the_widget( 'WP_Widget_Recent_Posts', null, $widget_args ); ?>
								</div>
							</div>
						<?php endif; ?>
						
						<div class="small-12 medium-6 columns">
							<div class="widget widget_archives">
								<?php the_widget( 'WP_Widget_Archives', array(
									'dropdown' => 1,
									'title'    => __( 'Monthly Archives', 'illuminate' )
								), $widget_args ); ?>
							</div>
						</div>
						
						<div class="small-12 medium-6 columns">
							<div class="widget widget_tags">
								<?php the_widget( 'WP_Widget_Tag_Cloud', null, $widget_args ); ?>
							</div>
						</div>
					</section>			
				</div>
			</div>
		</div>
	</div>
</main>

<?php get_footer(); ?>