<?php
/**
 * Theme Info
 *
 * Adds a simple Theme Info page to the Appearance section of the WordPress Dashboard.
 *
 * @package iknow
 */

/**
 * Add Theme Info page to admin menu
 */
function iknow_theme_info_menu_link() {

	// Get theme details.
	$theme = wp_get_theme();

	add_theme_page(
		sprintf( __( 'Welcome to %1$s %2$s', 'iknow' ), $theme->display( 'Name' ), $theme->display( 'Version' ) ),
		__( 'Theme Settings', 'iknow' ),
		'edit_theme_options',
		'iknow',
		'iknow_theme_info_page',
        1
	);

}

add_action( 'admin_menu', 'iknow_theme_info_menu_link' );

/**
 * Display Theme Info page
 */
function iknow_theme_info_page() {

	// Get theme details.
	$theme = wp_get_theme();
	?>

    <div class="wowp wrap theme-info-wrap">

        <h1><?php printf( __( 'Welcome to %1$s %2$s', 'iknow' ), $theme->display( 'Name' ), $theme->display( 'Version' ) ); ?></h1>

        <div class="theme-description"><?php echo esc_html( $theme->display( 'Description' ) ); ?></div>

        <hr>
        <div class="important-links clearfix">
            <p><strong><?php esc_html_e( 'Plugins for Best Experience', 'iknow' ); ?>:</strong>
                <a href="https://wordpress.org/plugins/flexi-menu/" target="_blank">
				    <?php esc_html_e( 'Flexi Menu', 'iknow' ); ?>
                </a>

                <a href="https://wordpress.org/plugins/buttons/"
                   target="_blank"><?php esc_html_e( 'Buttons', 'iknow' ); ?></a>

                <a href="https://wordpress.org/plugins/popup-box/"
                   target="_blank"><?php esc_html_e( 'Popup Box', 'iknow' ); ?>
                </a>

                <a href="https://wordpress.org/plugins/counter-box/" target="_blank">
				    <?php esc_html_e( 'Counter Box', 'iknow' ); ?>
                </a>

            </p>
        </div>
        <hr>

        <div id="getting-started">

            <h3><?php printf( __( 'Getting Started with %s', 'iknow' ), $theme->display( 'Name' ) ); ?></h3>

            <div class="columns-wrapper clearfix">

                <div class="column column-half clearfix">

                    <div class="section">
                        <h4><?php esc_html_e( 'Theme Options', 'iknow' ); ?></h4>

                        <p class="about">
							<?php printf( __( '%s makes use of the Customizer for all theme settings. Click on "Customize Theme" to open the Customizer now.', 'iknow' ), $theme->display( 'Name' ) ); ?>
                        </p>
                        <p>
                            <a href="<?php echo wp_customize_url(); ?>"
                               class="button button-primary"><?php esc_html_e( 'Customize Theme', 'iknow' ); ?></a>
                        </p>
                    </div>

                </div>

                <div class="column column-half clearfix">

                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/screenshot.png"/>

                </div>

            </div>

        </div>

        <hr>


        <div id="theme-author">

            <p>
				<?php printf( __( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'iknow' ),
					$theme->display( 'Name' ),
					'<a target="_blank" href="https://profiles.wordpress.org/wpcalc/" title="Wow-Company">Wow-Company</a>',
					'<a target="_blank" href="https://wordpress.org/support/theme/iknow/reviews/" title="' . esc_attr__( 'Review Iknow', 'iknow' ) . '">' . esc_html__( 'rate it', 'iknow' ) . '</a>'
				); ?>
            </p>

        </div>

    </div>

	<?php
}

/**
 * Enqueues CSS for Theme Info page
 *
 * @param int $hook Hook suffix for the current admin page.
 */
function iknow_theme_info_page_css( $hook ) {

	// Load styles and scripts only on theme info page.
	if ( 'appearance_page_iknow' !== $hook ) {
		return;
	}

	// Embed theme info css style.
	wp_enqueue_style( 'iknow-theme-info-css', get_template_directory_uri() . '/assets/css/theme-info.css' );

}

add_action( 'admin_enqueue_scripts', 'iknow_theme_info_page_css' );
