<?php
/**
 * Functions and definitions
 *
 * @package Iknow
 * @subpackage Iknow
 * @since Iknow 1.0
 */

if ( ! defined( 'IKNOW_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'IKNOW_VERSION', '1.3' );
}

if ( ! function_exists( 'iknow_setup' ) ) :
	function iknow_setup() {
		// keep the media in check
		if ( ! isset( $content_width ) ) {
			$content_width = 762;
		}

		/*
			* Make theme available for translation.
			* Translations can be filed in the /languages/ directory.
		*/
		load_theme_textdomain( 'iknow', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
			 * Let WordPress manage the document title.
			 * By adding theme support, we declare that this theme does not use a
			 * hard-coded <title> tag in the document head, and expect WordPress to
			 * provide it for us.
			 */
		add_theme_support( 'title-tag' );

		/*
			* This theme styles the visual editor to resemble the theme style,
			* specifically font, colors, icons, and column width.
		*/
//		add_editor_style( array( 'inc/assets/css/editor-style.css', get_template_directory() ) );

		// Enable support for Custom Logo for site.
		add_theme_support( 'custom-logo', array(
			'height' => 30,
		) );

		/*
			* Enable support for Post Thumbnails on posts and pages.
		*/
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'start-nav' => esc_attr__( 'Left Menu', 'iknow' ),
			'end-nav'   => esc_attr__( 'Right Menu', 'iknow' ),
			'footer'    => esc_attr__( 'Footer Menu', 'iknow' ),
		) );

		// Enable support for HTML5 markup.
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );
	}
endif;
add_action( 'after_setup_theme', 'iknow_setup' );

function iknow_scripts() {
	$iknow_option = get_option( 'iknow_settings', '' );
	$fontawesome  = ! empty( $iknow_option['fontawesome'] ) ? 1 : 0;
	$dashicons    = ! empty( $iknow_option['dashicons'] ) ? 1 : 0;
	$pre_suffix   = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	$template_uri = get_template_directory_uri();

	wp_enqueue_style( 'iknow-style', get_stylesheet_uri(), array(), IKNOW_VERSION );
	wp_style_add_data( 'iknow-style', 'rtl', 'replace' );

	wp_enqueue_style('iknow-icons', $template_uri . '/assets/icons/css/icons.css', '', '1.0');

	if ( $fontawesome ) {
		wp_enqueue_style( 'fontawesome', $template_uri . '/assets/vendors/fontawesome/css/all' . $pre_suffix . '.css', '', '5.12.0' );
	}

	if ( $dashicons ) {
		wp_enqueue_style( 'dashicons' );
	}

	if ( ! iknow_is_amp() ) {
		wp_enqueue_script( 'iknow', $template_uri . '/assets/js/script' . $pre_suffix . '.js', array(), IKNOW_VERSION, true );
	}
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', 'iknow_scripts' );


function iknow_admin_scripts( $hook_suffix ) {
	if ( $hook_suffix === 'edit.php' || $hook_suffix === 'edit-comments.php' ) {
		$template_uri = get_template_directory_uri();
		$pre_suffix   = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		wp_enqueue_style( 'admin-iknow', $template_uri . '/assets/css/admin-style' . $pre_suffix . '.css', '', '1.0' );
	}
}

add_action( 'admin_enqueue_scripts', 'iknow_admin_scripts' );

function iknow_widgets_init() {
	register_sidebar( array(
		'name'          => esc_attr__( 'Sidebar', 'iknow' ),
		'id'            => 'sidebar',
		'before_widget' => '<div id="%1$s" class="widget %2$s box">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="title is-size-4">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Left', 'iknow' ),
		'id'            => 'footer-sidebar-1',
		'before_widget' => '<div id="%1$s" class="widget %2$s box is-shadowless has-background-white-bis is-size-7">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="title is-size-5">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Center', 'iknow' ),
		'id'            => 'footer-sidebar-2',
		'before_widget' => '<div id="%1$s" class="widget %2$s box is-shadowless has-background-white-bis is-size-7">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="title is-size-5">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Right', 'iknow' ),
		'id'            => 'footer-sidebar-3',
		'before_widget' => '<div id="%1$s" class="widget %2$s box is-shadowless has-background-white-bis is-size-7">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="title is-size-5">',
		'after_title'   => '</h4>',
	) );

}

add_action( 'widgets_init', 'iknow_widgets_init' );

require get_template_directory() . '/inc/class-navigation.php';
require get_template_directory() . '/inc/class-comments.php';
require get_template_directory() . '/inc/extra-functions.php';
require get_template_directory() . '/inc/extra-single.php';
require get_template_directory() . '/inc/home-posts.php';
require get_template_directory() . '/inc/extra-archive.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/widgets.php';


/**
 * Checks if AMP page is rendered.
 */
function iknow_is_amp() {
	return function_exists( 'is_amp_endpoint' ) && is_amp_endpoint();
}


/**
 * Adds amp support for menu toggle.
 */
function iknow_amp_menu_toggle() {
	if ( iknow_is_amp() ) {
		echo "[aria-expanded]=\"mainMenuExpanded? 'true' : 'false'\" ";
		echo 'on="tap:AMP.setState({mainMenuExpanded: !mainMenuExpanded})" ';
		echo "[class]=\"'navbar-burger' + ( mainMenuExpanded ? ' is-active' : '' )\"";

	}
}


/**
 * Adds amp support for mobile dropdown navigation menu.
 */
function iknow_amp_menu_is_toggled() {
	if ( iknow_is_amp() ) {
		echo "[class]=\"'navbar-menu' + ( mainMenuExpanded ? ' is-active' : '' )\"";
	}
}

// Include Theme Info page.
require get_template_directory() . '/inc/theme-info.php';