<?php

$themename = "Ice Breaker";

$shortname = "ib";

$options = array (

array( "name" => "Sitewide",

"type" => "title"),

array( "type" => "open"),

array("name" => "Color",

"desc" => 'Choose your color scheme.',

"id" => $shortname."_color",

"options" => array('blue', 'red', 'green', 'gray'),

"std" => "blue",

"type" => "select"),

array( "name" => "I Have an Image Logo",

"desc" => "Check this box if you have an image logo (just upload logo-[color].png to Ice Breaker's 'images' directory)",

"id" => $shortname."_image_logo",

"type" => "checkbox",

"std" => "false"),

array( "name" => "Remove Description",

"desc" => "Check this box if you would like remove the description on your <strong>text</strong> logo",

"id" => $shortname."_remove_description",

"type" => "checkbox",

"std" => "false"),

array( "name" => "Short blurb",

"desc" => "Displayed below logo. Set to <em>Want to know when we launch?&lt;br/&gt;Subscribe by entering your e-mail below</em> by default.",

"id" => $shortname."_blurb",

"std" => "",

"type" => "text"),

array( "name" => "FeedBurner feed name",

"desc" => "Input your FeedBurner feed name here (just part in bold: http://feeds.feedburner.com/<strong>CustomTheme</strong>).",

"id" => $shortname."_feedburner_name",

"std" => "",

"type" => "text"),

array( "name" => "Subscription box text",

"desc" => "Set to <em>Enter your e-mail address here</em> by default",

"id" => $shortname."_box_text",

"std" => "",

"type" => "text"),

array( "name" => "Feed URL",

"desc" => "Input your entire feed URL here (<strong>http://feeds.feedburner.com/CustomTheme</strong>).",

"id" => $shortname."_feed_url",

"std" => "",

"type" => "text"),

array( "name" => "Twitter Username",

"desc" => "Input your Twitter username here.",

"id" => $shortname."_twitter_username",

"std" => "",

"type" => "text"),

array( "name" => "Remove Footer Link",

"desc" => "Check this box if you would like remove the CustomTheme.com logo link in the footer",

"id" => $shortname."_remove_link",

"type" => "checkbox",

"std" => "false"),

array( "type" => "close")

);

function mytheme_add_admin() {

global $themename, $shortname, $options;

if ( $_GET['page'] == basename(__FILE__) ) {

if ( 'save' == $_REQUEST['action'] ) {

foreach ($options as $value) {

update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

foreach ($options as $value) {

if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ] ); } else { delete_option( $value['id'] ); } }

header("Location: themes.php?page=functions.php&saved=true");

die;

} else if( 'reset' == $_REQUEST['action'] ) {

foreach ($options as $value) {

delete_option( $value['id'] ); }

header("Location: themes.php?page=functions.php&reset=true");

die;

}

}

add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

function mytheme_admin() {

global $themename, $shortname, $options;

if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';

if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

?>

<div class="wrap">

<h2><?php echo $themename; ?> Theme Options</h2>



<form method="post">



<?php foreach ($options as $value) {

switch ( $value['type'] ) {



case "open":

?>

<table width="100%" border="0">



<?php break;



case "close":

?>



</table><br />



<?php break;



case "title":

?>

<table width="100%" border="0" style="margin-bottom:15px;border-bottom:1px dotted #000000;"><tr>

<td colspan="2"><h3><?php echo $value['name']; ?></h3></td>

</tr>



<?php break;



case 'text':

?>



<tr>

<td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>

<td width="80%"><input style="width:400px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'] )); } else { echo $value['std']; } ?>" /></td>

</tr>



<tr>

<td><small><?php echo $value['desc']; ?></small></td>

</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>



<?php

break;



case 'textarea':

?>



<tr>

<td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>

<td width="80%"><textarea name="<?php echo $value['id']; ?>" style="width:400px; height:200px;" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'] )); } else { echo $value['std']; } ?></textarea></td>



</tr>



<tr>

<td><small><?php echo $value['desc']; ?></small></td>

</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>



<?php

break;



case 'select':

?>

<tr>

    <td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>

    <td width="80%"><select style="width:240px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $option) { ?><option<?php if ( get_option( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?></select></td>

</tr>



<tr>

    <td><small><?php echo $value['desc']; ?></small></td>

</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>



<?php

break;



case "checkbox":

?>

<tr>

<td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>

<td width="80%"><?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = ""; } ?>

<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />

</td>

</tr>



<tr>

<td><small><?php echo $value['desc']; ?></small></td>

</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #000000;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>



<?php

break;

}

}

?>

<form method="post">

<p class="submit">

<input name="save" type="submit" value="Save changes" />

<input type="hidden" name="action" value="save" />

</p>

</form>

<form method="post">

<p class="submit">

<input name="reset" type="submit" value="Reset" />

<input type="hidden" name="action" value="reset" />

</p>

</form>

<?php

}

add_action('admin_menu', 'mytheme_add_admin');

function unregister_default_wp_widgets() {

	unregister_widget('WP_Widget_Pages'); 

	unregister_widget('WP_Widget_Calendar');

	unregister_widget('WP_Widget_Archives');

	unregister_widget('WP_Widget_Links');

	unregister_widget('WP_Widget_Meta');

	unregister_widget('WP_Widget_Search');

	unregister_widget('WP_Widget_Categories');

	unregister_widget('WP_Widget_Recent_Posts');

	unregister_widget('WP_Widget_Recent_Comments');

	unregister_widget('WP_Widget_RSS');

	unregister_widget('WP_Widget_Tag_Cloud');

	unregister_widget('WP_Widget_Text');

} 

add_action('widgets_init', 'unregister_default_wp_widgets', 1);

if ( function_exists('register_sidebar') )

register_sidebar(array(

'before_widget' => '',

'after_widget' => '',

'before_title' => '',

'after_title' => '',

));

?>