<!-- Start the Loop. -->
<?php
if (have_posts()) :
    while (have_posts()) :
        the_post();
        ?>
        <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <h1 class="post_title"><a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
            <ul class="post_meta">
                <li class="posted_by"><span class="glyphicon glyphicon-user"></span><span><?php esc_html_e('Posted by', 'hustler'); ?></span>&nbsp;<?php esc_url(the_author_posts_link()); ?></li>
                <li class="post_date"><span class="glyphicon glyphicon-calendar"></span><span><?php esc_html_e('on', 'hustler'); ?></span>&nbsp;<?php the_time(get_option('date_format')); ?></li>
                <li class="post_category"><span class="glyphicon glyphicon-folder-open"></span>&nbsp;<span><?php esc_html_e('in', 'hustler'); ?></span>&nbsp;<?php the_category(', '); ?></li>
                <li class="postc_comment">&nbsp;<?php comments_popup_link(esc_html__('No Comments.', 'hustler'), esc_html__('1 Comment.', 'hustler'), esc_html__('% Comments.', 'hustler'), '', ''); ?></li>
            </ul>
            <div class="post_content"> 
                <?php
                if (has_post_thumbnail()) {
                    hustler_get_thumbnail(740, 555);
                } else {
                    hustler_get_image(740, 555);
                }
                the_excerpt();
                ?>
                <div class="clear"></div>
                <?php if (has_tag()) { ?>
                    <div class="tag">
                        <?php the_tags(__('Post Tagged with : ', 'hustler'), ', ', ''); ?>
                    </div>
                <?php } ?>
                
            </div>
        </div>
        <!--End post-->
        <?php
    endwhile;
else :
    ?>
    <div class="post">
        <p>
            <?php esc_html_e('Sorry, no posts matched your criteria.', 'hustler'); ?>
        </p>
    </div>
<?php endif; ?>
<!--End Loop-->
