<?php
/**
 * The template used to display Tag Archive pages
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="content-bar">
                    <?php if (have_posts()) : ?>
                        <h1 class="page_title"> 
                            <?php
                            echo esc_html(the_archive_title());
                            ?>
                        </h1>
                        <?php get_template_part('template-parts/content'); ?>
                        <div class="clear"></div>
                        <nav id="nav-single">
                            <?php
                            the_posts_navigation(
                                    array(
                                        'prev_text' => '<span class="screen-reader-text">' . __('Previous Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('&larr; Previous posts', 'hustler') . '</span>',
                                        'next_text' => '<span class="screen-reader-text">' . __('Next Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('Newer posts &rarr;', 'hustler') . '</span> ',
                                    )
                            );
                            ?>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-4">
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
