<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">  
                <div class="content-bar single_page">
                    <!-- Start the Loop. -->
                    <?php
                    if (have_posts()) :
                        while (have_posts()) :
                            the_post();
                            ?>
                            <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <h1 class="post_title"><?php the_title(); ?></h1>
                                <ul class="post_meta">
                                    <li class="posted_by"><span class="glyphicon glyphicon-user"></span><span><?php esc_html_e('Posted by', 'hustler'); ?></span>&nbsp;<?php the_author_posts_link(); ?></li>
                                    <li class="post_date"><span class="glyphicon glyphicon-calendar"></span><span><?php esc_html_e('on', 'hustler'); ?></span>&nbsp;<?php the_time(get_option('date_format')); ?></li>
                                    <li class="post_category"><span class="glyphicon glyphicon-folder-open"></span><span><?php esc_html_e(' in', 'hustler'); ?></span>&nbsp;<?php the_category(', '); ?></li>
                                    <li class="postc_comment">&nbsp;<?php comments_popup_link(__('No Comments.', 'hustler'), __('1 Comment.', 'hustler'), __('% Comments.', 'hustler'), '', ''); ?></li>
                                </ul>
                                <hr>
                                <div class="post_content"> 
                                    <?php the_content(); ?>
                                    <div class="clear"></div>
                                    <?php if (has_tag()) { ?>
                                        <div class="tag">
                                            <?php the_tags(esc_html__('Post Tagged with : ', 'hustler'), ', ', ''); ?>
                                        </div>
                                        <?php
                                    }
                                    wp_link_pages(
                                            array(
                                                'before' => '<div class="page-links"><span class="page-links-title">' . __('Pages:', 'hustler') . '</span>',
                                                'after' => '</div>',
                                                'link_before' => '<span>',
                                                'link_after' => '</span>',
                                                'pagelink' => '<span class="screen-reader-text">' . __('Page', 'hustler') . ' </span>%',
                                                'separator' => '<span class="screen-reader-text">, </span>',
                                            )
                                    );
                                    ?>
                                </div>
                            </div>
                            <div class="clear"></div>
                            <nav id="nav-single"> 
                                <?php
                                the_posts_navigation(
                                        array(
                                            'prev_text' => '<span class="screen-reader-text">' . __('Previous Post', 'hustler') . '</span><span aria-hidden="true" class="nav-previous">' . __('&larr; Previous posts', 'hustler') . '</span>',
                                            'next_text' => '<span class="screen-reader-text">' . __('Next Post', 'hustler') . '</span><span aria-hidden="true" class="nav-next">' . __('Newer posts &rarr;', 'hustler') . '</span> ',
                                        )
                                );
                                ?>
                            </nav>
                            <!--End post-->
                            <?php
                        endwhile;
                    endif;
                    ?>
                    <!--End Loop-->
                    <!--Start Comment box-->
                    <?php comments_template(); ?>
                    <!--End Comment box-->
                </div>
            </div>
            <div class="col-md-4">
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>
</div>
<div class="clear"></div>
<?php
get_footer();

