<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="content-bar">
                    <?php if (have_posts()) : ?>
                        <h1 class="page_title"><?php /* translators: %s - title */ printf(esc_html__('Search Results for: %s', 'hustler'), '' . get_search_query() . ''); ?></h1>
                        <!--Start Post-->
                        <?php get_template_part('template-parts/content'); ?>
                        <!--End Post-->
                    <?php else : ?>
                        <article id="post-0" class="post no-results not-found">
                            <h1 class="entry-title">
                                <?php esc_html_e('Nothing Found', 'hustler'); ?>
                            </h1>
                            <!-- .entry-header -->
                            <div class="entry-content">
                                <p>
                                    <?php esc_html_e('Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'hustler'); ?>
                                </p>
                                <?php get_search_form(); ?>
                            </div>
                            <!-- .entry-content -->
                        </article>
                    <?php endif; ?>
                    <div class="clear"></div>
                    <nav id="nav-single">
                        <?php
                        the_posts_navigation(
                                array(
                                    'prev_text' => '<span class="screen-reader-text">' . __('Previous Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('&larr; Previous posts', 'hustler') . '</span>',
                                    'next_text' => '<span class="screen-reader-text">' . __('Next Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('Newer posts &rarr;', 'hustler') . '</span> ',
                                )
                        );
                        ?>
                    </nav>	
                </div>
            </div>
            <div class="col-md-4">
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
