<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Hustler
 */
get_header('dynamic');
?>

<div id="primary" class="content-area page-content">
    <main id="main" class="site-main">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <div class="content-bar">
                        <?php
                        if (have_posts()) :
                            the_post();
                            ?>
                            <h1 class="page_title"><?php the_title(); ?></h1>
                            <?php
                            the_content();
                            wp_link_pages(
                                    array(
                                        'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__('Pages:', 'hustler') . '</span>',
                                        'after' => '</div>',
                                        'link_before' => '<span>',
                                        'link_after' => '</span>',
                                        'pagelink' => '<span class="screen-reader-text">' . esc_html__('Page', 'hustler') . ' </span>%',
                                        'separator' => '<span class="screen-reader-text">, </span>',
                                    )
                            );
                            comments_template();
                        endif;
                        ?>

                    </div>
                </div>
                <div class="col-md-4">
                    <!--Start Sidebar-->
                    <?php get_sidebar(); ?>
                    <!--End Sidebar-->
                </div>
            </div>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();
