<?php
class Hustler_Customizer {

    public static function hustler_register($wp_customize) {

        self::hustler_sections($wp_customize);

        self::hustler_controls($wp_customize);
    }

    public static function hustler_sections($wp_customize) {

        /**
         * Add panel for home page feature area
         */
        $wp_customize->add_panel(
                'general_setting_panel', array(
            'title' => __('General Settings', 'hustler'),
            'description' => __('Hustler General Setting', 'hustler'),
            'priority' => '10',
            'capability' => 'edit_theme_options',
                )
        );



        /**
         * Site Title Section
         */
        $wp_customize->add_section(
            'title_tagline', array(
            'title' => __('Site Title, Tagline & Logo', 'hustler'),
            'description' => __('Allows you to customize Site Title, Tagline, Icon and Logo ', 'hustler'),
            'priority' => '',
            'panel' => 'general_setting_panel',
                )
        );

        /**
         * Header section
         */
        $wp_customize->add_section(
                'header_setting', array(
            'title' => __('Header Setting', 'hustler'),
            'description' => __('Allows you to customize Header background and font color', 'hustler'), // Descriptive tooltip
            'panel' => 'general_setting_panel',
            'priority' => '',
            'capability' => 'edit_theme_options',
                )
        );

        $wp_customize->add_section(
                'hustler_hp_head_set', array(
            'title' => __('Home Page Head Section', 'hustler'),
            'description' => __('Allows you to customize Background Image, Heading and Sub Heading of Home page Head Section ', 'hustler'), // Descriptive tooltip
            'priority' => '11',
                )
        );
        

        $wp_customize->add_section(
                'hustler_footer_set', array(
            'title' => __('Footer Setting', 'hustler'),
            'description' => __('Allows you to customize Footer Text', 'hustler'), // Descriptive tooltip
            'priority' => '201',
                )
        );
    }

    public static function hustler_section_content() {

        $section_content = array(
            
            'header_setting' => array(
                'hustler_hp_header_bg_col',
                
            ),

            'hustler_hp_head_set' => array(
                'hustler_hp_head_sec_bg_img',

            ),

            'hustler_footer_set' => array(
                'hustler_footer_txt',
            ),
        );
        return $section_content;
    }

    public static function hustler_settings() {

        $theme_settings = array(
           
            'hustler_hp_header_bg_col' => array(
                'id' => 'hustler_options[hustler_hp_header_bg_col]',
                'label' => __('Header Background color', 'hustler'),
                'description' => __('Select background Color for Header Section </br></br><strong>If Header image is set background color will not be applied to set background color please remove background image and vice versa</strong>', 'hustler'),
                'type' => 'option',
                'setting_type' => 'color',
                'default' => '#2c4eaf',
            ),
            

            'hustler_hp_head_sec_bg_img' => array(
                'id' => 'hustler_options[hustler_hp_head_sec_bg_img]',
                'label' => __('Background Image', 'hustler'),
                'description' => __('Set Background Image for head section', 'hustler'),
                'type' => 'option',
                'default' => '',
                'setting_type' => 'image',
            ),

           
            'hustler_footer_txt' => array(
                'id' => 'hustler_options[hustler_footer_txt]',
                'label' => __('Footer Text', 'hustler'),
                'description' => __('Enter Footer Text.', 'hustler'),
                'type' => 'option',
                'setting_type' => 'text',
                'default' => '',
            ),
        );
        return $theme_settings;
    }

    public static function hustler_controls($wp_customize) {

        $sections = self::hustler_section_content();
        $settings = self::hustler_settings();
        
         /*
         * Begin: Calling Selective refresh function for each settings.
         */
        foreach ($settings as $k => $v) {
            $wp_customize->selective_refresh->add_partial($v['id'], array(
                'selector' => '.' . $k,
            ));
        }
        /*
         * End: Calling Selective refresh function for each settings.
         */

        foreach ($sections as $section_id => $section_content) {

            foreach ($section_content as $section_content_id) {

                switch ($settings[$section_content_id]['setting_type']) {
                    case 'image':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_url');
                        $wp_customize->add_control(
                                new WP_Customize_Image_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                                )
                                )
                        );
                        break;

                    case 'text':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_text');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'text',
                                )
                                )
                        );
                        break;

                    case 'textarea':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_textarea');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'textarea',
                                )
                                )
                        );
                        break;

                    case 'link':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_url');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'text',
                                )
                                )
                        );
                        break;

                    case 'color':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_color');

                        $wp_customize->add_control(
                                new WP_Customize_Color_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                                )
                                )
                        );
                        break;

                    case 'number':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_number');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'text',
                                )
                                )
                        );
                        break;

                    case 'select':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_select');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'select',
                            'choices' => $settings[$section_content_id]['choices'],
                                )
                                )
                        );
                        break;

                    case 'radio':
                        self::add_setting($wp_customize, $settings[$section_content_id]['id'], $settings[$section_content_id]['default'], $settings[$section_content_id]['type'], 'hustler_sanitize_radio');

                        $wp_customize->add_control(
                                new WP_Customize_Control(
                                $wp_customize, $settings[$section_content_id]['id'], array(
                            'label' => $settings[$section_content_id]['label'],
                            'description' => $settings[$section_content_id]['description'],
                            'section' => $section_id,
                            'settings' => $settings[$section_content_id]['id'],
                            'type' => 'radio',
                            'choices' => $settings[$section_content_id]['choices'],
                                )
                                )
                        );
                        break;

                    default:
                        break;
                }
            }
        }
    }

    public static function add_setting($wp_customize, $setting_id, $default, $type, $sanitize_callback) {
        $wp_customize->add_setting(
                $setting_id, array(
            'default' => $default,
            'capability' => 'edit_theme_options',
            'sanitize_callback' => array('Hustler_Customizer', $sanitize_callback),
            'type' => $type,
                )
        );
    }

    /**
     * adds sanitization callback funtion : textarea
     *
     * @package Hustler
     */
    public static function hustler_sanitize_textarea($value) {
        $value = sanitize_textarea_field($value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : url
     *
     * @package Hustler
     */
    public static function hustler_sanitize_url($value) {
        $value = esc_url_raw($value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : text
     *
     * @package Hustler
     */
    public static function hustler_sanitize_text($value) {
        $value = sanitize_text_field($value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : email
     *
     * @package Hustler
     */
    public static function hustler_sanitize_email($value) {
        $value = sanitize_email($value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : number
     *
     * @package Hustler
     */
    public static function hustler_sanitize_number($value) {
        $value = preg_replace('/[^0-9+ ]/', '', $value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : number
     *
     * @package Hustler
     */
    public static function hustler_sanitize_color($value) {
        $value = sanitize_hex_color($value);
        return $value;
    }

    /**
     * adds sanitization callback funtion : select
     *
     * @package Hustler
     */
    public static function hustler_sanitize_select($value, $setting) {
        global $wp_customize;
        $control = $wp_customize->get_control($setting->id);
        if (array_key_exists($value, $control->choices)) {
            return $value;
        } else {
            return $setting->default;
        }
    }

    /**
     * adds sanitization callback funtion : radio
     *
     * @package Hustler
     */
    public static function hustler_sanitize_radio($value, $setting) {
        global $wp_customize;
        $control = $wp_customize->get_control($setting->id);
        if (array_key_exists($value, $control->choices)) {
            return $value;
        } else {
            return $setting->default;
        }
    }

}

// Setup the Theme Customizer settings and controls...
add_action('customize_register', array('Hustler_Customizer', 'hustler_register'));

/**
 * Enqueue script for custom customize control.
 */
function theme_slug_custom_customize_enqueue() {
    wp_enqueue_style('customizer-css', get_template_directory_uri() . '/assets/css/customizer.css');
}

add_action('customize_controls_enqueue_scripts', 'theme_slug_custom_customize_enqueue');

// Enqueue our scripts and styles
function hustler_customize_controls_scripts() {

    wp_enqueue_script('hustler-customize-controls', get_theme_file_uri('/inc/customizer_assets/hustler-customize-controls.js'), array(), '1.0', true);
}

add_action('customize_controls_enqueue_scripts', 'hustler_customize_controls_scripts');

function hustler_customize_controls_styles() {

    wp_enqueue_style('hustler-customize-controls', get_theme_file_uri('/inc/customizer_assets/hustler-customize-controls.css'), array(), '1.0');
}

add_action('customize_controls_print_styles', 'hustler_customize_controls_styles');

function hustler_customize_register($wp_customize) {
      //blog name and description
    $wp_customize->get_setting('blogname');
    $wp_customize->get_setting('blogdescription');
// Add the selective part


    $wp_customize->selective_refresh->add_partial('blogname', array(
        'selector' => '.site-title a',
        'render_callback' => 'false',
    ));
    $wp_customize->selective_refresh->add_partial('blogdescription', array(
        'selector' => '.site-description',
        'render_callback' => 'false',
    ));

}

add_action('customize_register', 'hustler_customize_register');


/**
 * Class to add additional section in the customizer 
 *
 * @since  1.2.6
 * @access public
 * 
 * Hustler WordPress Theme incorporates the following code from Git Hub (https://github.com/justintadlock/trt-customizer-pro), Copyright 2016 © Justin Tadlock.
 * ColorWay WordPress Theme is distributed under the terms of the GNU GPL
 */
final class Hustler_Custom_Section{
	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {
		static $instance = null;
		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}
		return $instance;
	}
	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}
	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {
		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

	}
	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {            
		// Load custom sections.
		require_once( trailingslashit( get_template_directory() ) . '/inc/customizer_assets/class-customizer-section-pro.php' );
		// Register custom section types.
		$manager->register_section_type( 'Hustler_Customize_Section_Pro' );
		// Register sections.
		$manager->add_section(
			new Hustler_Customize_Section_Pro(
				$manager,
				'hustler_pro',
				array(
					'title'    => esc_html__( 'View Hustler Pro', 'hustler' ),
					'pro_text' => esc_html__( 'Go Pro', 'hustler' ),
					'pro_url'  => 'https://www.pabbly.com/hustler-wordpress-theme/',
                                        'priority' => '220',
				)
			)
		);
	}

}
// Doing this customizer thang!
Hustler_Custom_Section::get_instance();