<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Hustler
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="<?php esc_url('http://gmpg.org/xfn/11'); ?>" />
        <link rel="pingback" href="<?php esc_url(bloginfo('pingback_url')); ?>" />
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
        <div id="page" class="site">
            <header>
                <div class="container">
                    <div class="row">
                        <div class="head_content">
                            <div class="col-md-3 col-sm-2">
                                <div class="head_logo">

                                    <?php
                                    if (has_custom_logo()) {
                                        the_custom_logo();
                                    } else {
                                        ?>
                                        <hgroup class="site_title_descrip">
                                            <h1 class="site-title"><a style="color: #<?php esc_attr(header_textcolor()); ?>" href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                            <h5 class="site-description" style="color: #<?php esc_attr(header_textcolor()); ?>"><?php bloginfo('description'); ?></h5>
                                        </hgroup>
                                    <?php } ?>

                                </div>
                            </div>
                            <div class="col-md-9 col-sm-10">
                                <div class="my_menu">
                                    <nav id="site-navigation" class="main-navigation">
                                        <?php
                                        if (has_nav_menu('menu-1')) {
                                            wp_nav_menu(
                                                    array(
                                                        'theme_location' => 'menu-1',
                                                        'menu_id' => 'primary-menu',
                                                    )
                                            );
                                        } else {
                                            ?>                                                                                  
                                            <ul id='primary-menu' class="menu">
                                                <?php
                                                wp_list_pages('title_li=&show_home=1&sort_column=menu_order');
                                                ?>
                                            </ul> 
                                        <?php }
                                        ?>
                                    </nav><!-- #site-navigation -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            </header><!-- #masthead -->

