<?php

/**
 * Hustler functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Hustler
 */
if (!function_exists('hustler_setup')) :

    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function hustler_setup() {

        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on hustler, use a find and replace
         * to change 'hustler' to the name of your theme in all the template files.
         */
        load_theme_textdomain('hustler', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        add_editor_style();

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(
                array(
                    'menu-1' => esc_html__('Primary', 'hustler')
                )
        );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support(
                'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
                )
        );

        // Set up the WordPress core custom background feature.
        add_theme_support(
                'custom-background', apply_filters(
                        'pabbly_custom_background_args', array(
            'default-color' => '#fff',
            'default-image' => '',
                        )
                )
        );

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support(
                'custom-logo', array(
            'height' => 250,
            'width' => 250,
            'flex-width' => true,
            'flex-height' => true,
                )
        );


        add_theme_support('custom-header', array(
            'default-image' => '',
            'random-default' => false,
            'width' => '',
            'height' => '',
            'flex-height' => true,
            'flex-width' => true,
            'default-text-color' => '',
            'header-text' => true,
            'uploads' => true,
            'wp-head-callback' => '',
            'admin-head-callback' => '',
            'admin-preview-callback' => ''
        ));


        // Define and register starter content to showcase the theme on new sites.
//        $starter_content = apply_filters('hustler_starter_content', $starter_content);

        add_theme_support('starter-content', array(
            // Set up nav menus for the theme.
            'nav_menus' => array(
                // Assign a menu to the "menu-1" location.
                'menu-1' => array(
                    'name' => __('Top Menu', 'hustler'),
                    'items' => array(
                        'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.
                    ),
                ),
            ),
            
            'widgets' => array(
                'page_header_widget' => array(
                    'my_html10' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<h1 class="hustler_hp_head_sec_head">Promote, Manage, Analyse & Grow Your Business Online.</h1>'
                        ),
                    ),

                    'my_html11' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<h4 class="hustler_hp_head_sec_desc">We have everything for your business that your sales team needs.</h4>'
                        ),
                    ),
                ),

                'feature_area_widget_1' => array(
                    'my_html1' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<div class=""><i class="fa fa-envelope fa-2x" aria-hidden="true"></i><h4>EmailMarketing</h4></div>'
                        ),
                    ),
                    'my_html2' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<p class="hustler_hp_feat_sec_desc_1">Convert your subscribers into paying customers by sending emails & keep them engage with your services with our email marketing software.</p>',
                        ),
                    ),
                    'my_html3' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<a href="#"><input type="submit" class="feat_btn btn_feat_4 comn_btn_4 hustler_hp_feat_sec_btn_txt_1" value="Let\'s Explore"></a>',
                        ),
                    ),
                ),

                'feature_area_widget_2' => array(
                    'my_html4' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<div class=""><i class="fa fa-envelope fa-2x" aria-hidden="true"></i><h4>EmailMarketing</h4></div>'
                        ),
                    ),
                    'my_html5' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<p class="hustler_hp_feat_sec_desc_1">Convert your subscribers into paying customers by sending emails & keep them engage with your services with our email marketing software.</p>',
                        ),
                    ),
                    'my_html6' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<a href="#"><input type="submit" class="feat_btn btn_feat_4 comn_btn_4 hustler_hp_feat_sec_btn_txt_1" value="Let\'s Explore"></a>',
                        ),
                    ),
                ),

                'feature_area_widget_3' => array(
                    'my_html7' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<div class=""><i class="fa fa-envelope fa-2x" aria-hidden="true"></i><h4>EmailMarketing</h4></div>'
                        ),
                    ),
                    'my_html8' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<p class="hustler_hp_feat_sec_desc_1">Convert your subscribers into paying customers by sending emails & keep them engage with your services with our email marketing software.</p>',
                        ),
                    ),
                    'my_html9' => array(
                        // Widget $id -> set when creating a Widget Class
                        'custom_html',
                        // Widget $instance -> settings
                        array(
                            'content' => '<a href="#"><input type="submit" class="feat_btn btn_feat_4 comn_btn_4 hustler_hp_feat_sec_btn_txt_1" value="Let\'s Explore"></a>',
                        ),
                    ),
                ),
                
                
                // Place three core-defined widgets in the sidebar area.
                'sidebar-1' => array(
                    'search',
                    'categories',
                    'recent-posts',
                ),
                'foot_area_1' => array(
                    'my_text' => array(
                        // Widget $id -> set when creating a Widget Class
                        'text',
                        // Widget $instance -> settings 
                        array(
                            'title' => __('Footer Widget', 'hustler'),
                            'text' => __('Footer is widgetized. To setup the footer, drag the required Widgets in Appearance -> Widgets Tab in the First, Second, Third, Fourth and Five Footer Widget Areas.', 'hustler'),
                        ),
                    ),
                ),
                // Add the core-defined business info widget to the footer 1 area.
                'foot_area_2' => array(
                    'meta',
                ),
                // Put two core-defined widgets in the footer 2 area.
                'foot_area_3' => array(
                    'text_about',
                ),
                'foot_area_4' => array(
                    'archives',
                ),
                'foot_area_5' => array(
                    'categories'
                ),
            ),
                )
        );
    }

endif;
add_action('after_setup_theme', 'hustler_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function hustler_content_width() {
    $GLOBALS['content_width'] = apply_filters('hustler_content_width', 640);
}

add_action('after_setup_theme', 'hustler_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function hustler_widgets_init() {



    register_sidebar(
            array(
                'name' => esc_html__('Sidebar', 'hustler'),
                'id' => 'sidebar-1',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );
    register_sidebar(
            array(
                'name' => esc_html__('Footer Widget Area 1', 'hustler'),
                'id' => 'foot_area_1',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );
    register_sidebar(
            array(
                'name' => esc_html__('Footer Widget Area 2', 'hustler'),
                'id' => 'foot_area_2',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );
    register_sidebar(
            array(
                'name' => esc_html__('Footer Widget Area 3', 'hustler'),
                'id' => 'foot_area_3',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );
    register_sidebar(
            array(
                'name' => esc_html__('Footer Widget Area 4', 'hustler'),
                'id' => 'foot_area_4',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );
    register_sidebar(
            array(
                'name' => esc_html__('Footer Widget Area 5', 'hustler'),
                'id' => 'foot_area_5',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );

    register_sidebar(
            array(
                'name' => esc_html__('Page Header Widget', 'hustler'),
                'id' => 'page_header_widget',
                'description' => esc_html__('Add widgets here.', 'hustler'),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget' => '</section>',
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            )
    );

    register_sidebar(
        array(
            'name' => esc_html__('Feature Area Widget One', 'hustler'),
            'id' => 'feature_area_widget_1',
            'description' => esc_html__('Add widgets here.', 'hustler'),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget' => '</section>',
            'before_title' => '<h2 class="widget-title">',
            'after_title' => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name' => esc_html__('Feature Area Widget Two', 'hustler'),
            'id' => 'feature_area_widget_2',
            'description' => esc_html__('Add widgets here.', 'hustler'),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget' => '</section>',
            'before_title' => '<h2 class="widget-title">',
            'after_title' => '</h2>',
        )
    );

    register_sidebar(
        array(
            'name' => esc_html__('Feature Area Widget Three', 'hustler'),
            'id' => 'feature_area_widget_3',
            'description' => esc_html__('Add widgets here.', 'hustler'),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget' => '</section>',
            'before_title' => '<h2 class="widget-title">',
            'after_title' => '</h2>',
        )
    );

  

    register_default_headers(array(
        'default-image' => array(
            'url' => '',
            'thumbnail_url' => '',
            'description' => __('Default Header Image', 'hustler')
        ),
    ));
}

add_action('widgets_init', 'hustler_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function hustler_styles() {
    wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');

    wp_enqueue_style('flexslider', get_template_directory_uri() . '/assets/css/flexslider.css');

    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/fonts/font-awesome.min.css');

    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/fonts/font-awesome.css');

    wp_enqueue_style('hustler-style', get_stylesheet_uri());

    wp_enqueue_style('responsive', get_template_directory_uri() . '/assets/css/responsive.css');

    wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.css');

    wp_enqueue_style('meanmenu', get_template_directory_uri() . '/assets/css/meanmenu.css');

//    wp_enqueue_style( 'sm-simple', get_template_directory_uri() . '/assets/css/sm-simple.css' );
//    wp_enqueue_style( 'sm-simple', get_template_directory_uri() . '/assets/css/sm-simple.css' );

    wp_enqueue_style('hustler-google-fonts', '//fonts.googleapis.com/css?family=Lato:100,100i,300,300i,400,400i,700,700i,900,900i');

//	wp_enqueue_style( 'ddsmoothmenu', get_template_directory_uri() . '/assets/css/ddsmoothmenu.css' );
}

add_action('wp_enqueue_scripts', 'hustler_styles');

function hustler_scripts() {//	
  wp_enqueue_script('jquery-flexslider-js', get_template_directory_uri() . '/assets/js/jquery.flexslider.js', array('jquery'));


    wp_enqueue_script('jquery-meanmenu-js', get_template_directory_uri() . '/assets/js/jquery.meanmenu.js', array('jquery'));

    // wp_enqueue_script( 'jquery-smartmenu-js', get_template_directory_uri() . '/assets/js/jquery.smartmenus.js', array( 'jquery' ) );

    wp_enqueue_script('hustler-custom-js', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'));

    wp_enqueue_script('hustler-jquery-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array('jquery'), '20151215', true);

    wp_enqueue_script('hustler-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array('jquery'), '20151215', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
    
    
}

add_action('wp_enqueue_scripts', 'hustler_scripts');


/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';


/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * This function thumbnail id and
 * returns thumbnail image
 *
 * @param type $iw
 * @param type $ih
 */
function hustler_get_thumbnail($iw, $ih) {
    $permalink = get_permalink();
    $thumb = get_post_thumbnail_id();
    $image = wp_get_attachment_image_src($thumb, 'full');
    if (!empty($image) && has_post_thumbnail()) {
        print "<a href='" . esc_url($permalink) . "'><img class='postimg' src='" . esc_url($image[0]) . "' width='" . esc_attr($iw) . "' height='" . esc_attr($ih) . "' /></a>";
    }
}

/**
 * This function gets image width and height and
 * Prints attached images from the post
 */
function hustler_get_image($width, $height, $return = false) {
    $w = $width;
    $h = $height;
    global $post, $posts;
    /**
     * This is required to set to Null
     */
    $img_source = '';
    $permalink = get_permalink();
    ob_start();
    ob_end_clean();
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
    if (isset($matches [1] [0])) {
        $img_source = $matches [1] [0];
        if (!empty($img_path)) {
            if ($return) {
                return "<a href='" . esc_url($permalink) . "'><img src='" . esc_url($img_source) . "' class='postimg img-thumbnail' /></a>";
            } else {
                echo "<a href='" . esc_url($permalink) . "'><img src='" . esc_url($img_source) . "' class='postimg img-thumbnail' /></a>";
            }
        }
    }
}

/**
 * Trim excerpt
 */
function hustler_custom_trim_excerpt($length) {
    global $post;
    $explicit_excerpt = $post->post_excerpt;
    if ('' == $explicit_excerpt) {
        $text = get_the_content('');
        $text = apply_filters('the_content', $text);
        $text = str_replace(']]>', ']]>', $text);
    } else {
        $text = apply_filters('the_content', $explicit_excerpt);
    }
    $text = strip_shortcodes($text); // optional
    $text = strip_tags($text);
    $excerpt_length = $length;
    $words = explode(' ', $text, $excerpt_length + 1);
    if (count($words) > $excerpt_length) {
        array_pop($words);
        array_push($words, '...');
        $text = implode(' ', $words);
        $text = apply_filters('the_excerpt', $text);
    }
    return $text;
}

/**
 * Custom CSS And Header Font Color Styles
 * */
function hustler_head_css() {
    global $post;
    $output = '';
    $header_font = hustler_get_option('hustler_hp_header_font_col');
    $head_bg_img = hustler_get_option('hustler_hp_head_sec_bg_img');

    if ($header_font <> '') {
        $output .= '.my_menu ul li a {
     color: ' . $header_font . ';} .yes_child:after{color:' . $header_font . ";} \n";
    }
    if ($head_bg_img <> '') {
        $output .= '.page_head {
    background-image: url(' . esc_url($head_bg_img) . ');}';
    }

    // Output styles.
    if ($output <> '') {
        echo "<!-- Custom Styling -->\n<style type=\"text/css\">\n" . esc_html($output) . "</style>\n";
    }
}

add_action('wp_head', 'hustler_head_css');

// get the theme option from options array.
function hustler_get_option($name, $default = '') {
    $options = get_option('hustler_options');
    if (isset($options[$name]) && $options[$name] != '') {
        return $options[$name];
    } else {
        return false;
    }
}


/**
 * Filter the except length to 20 words.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function hustler_custom_excerpt_length( $length ) {
    return 25;
}
add_filter( 'excerpt_length', 'hustler_custom_excerpt_length', 999 );


/**
 * Filter the excerpt "read more" string.
 *
 * @param string $more "Read more" excerpt string.
 * @return string (Maybe) modified "read more" excerpt string.
 */
function hustler_excerpt_more( $more ) {
    return sprintf( '<a class="read_more" href="%1$s">%2$s</a>',
        get_permalink( get_the_ID() ),
        __( 'Read More  ...', 'hustler' )
    );
}
add_filter( 'excerpt_more', 'hustler_excerpt_more' );

function hustler_header_bg_img() {
    
     if(get_header_image()!=''){
        echo '<style type="text/css"> header{ background-image:url(' . esc_url( get_header_image() ) . '); background-repeat: no-repeat;
                    background-position: center; background-size: cover;}</style>';
    }
    
    if(hustler_get_option('hustler_hp_header_bg_col') != ''){
         echo '<style type="text/css"> header{ background:' . esc_attr(hustler_get_option('hustler_hp_header_bg_col')) . '}</style>';
        
    }

}
add_action( 'wp_head', 'hustler_header_bg_img');


