<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Hustler
 */
?>


<footer>
    <div class="container">
        <div class="row">
            <div class="footer_con">
                <div class="my_footer col-md-3 col-sm-4 col-xs-6">
                    <?php
                    if (is_active_sidebar('foot_area_1')) {
                        dynamic_sidebar('foot_area_1');
                    }
                    ?>

                </div>
                <div class="my_footer col-md-9 col-sm-8 col-xs-6">
                    <div class="row">
                        <div class="my_full col-md-3 col-sm-3 col-xs-6">
                            <?php
                            if (is_active_sidebar('foot_area_2')) {
                                dynamic_sidebar('foot_area_2');
                            }
                            ?>

                        </div>
                        <div class="my_full col-md-3 col-sm-3 col-xs-6">
                            <?php
                            if (is_active_sidebar('foot_area_3')) {
                                dynamic_sidebar('foot_area_3');
                            }
                            ?>

                        </div>
                        <div class="my_full col-md-3 col-sm-3 col-xs-6">
                            <?php
                            if (is_active_sidebar('foot_area_4')) {
                                dynamic_sidebar('foot_area_4');
                            }
                            ?>

                        </div>
                        <div class="my_full col-md-3 col-sm-3 col-xs-6">
                            <?php
                            if (is_active_sidebar('foot_area_5')) {
                                dynamic_sidebar('foot_area_5');
                            }
                            ?>

                        </div>
                    </div>
                </div>
                <div class="copy_right col-md-12">
                    <span class="hustler_footer_txt"><a rel="nofollow" href="#">&copy; <?php echo esc_html(date_i18n(__('Y', 'hustler'))) . ' '; ?>
                            <?php
                            if (hustler_get_option('hustler_footer_txt') != '') {
                                echo wp_kses_post(hustler_get_option('hustler_footer_txt'));
                            } else {
                                esc_html_e(' Hustler', 'hustler');
                            }
                            ?>
                        </a></span>  
                </div>
            </div>

        </div>
    </div>
</footer>
<?php wp_footer(); ?>
</body>
</html>
