<?php
/**
 * Template Name: Blog Page
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="content-bar">
                    <?php
                    $img_data = 1;
                    if (have_posts()) :
                        while (have_posts()) :
                            the_post();
                            ?>
                            <div id="post-<?php the_ID(); ?>" class="post <?php post_class(); ?>">
                                <h1 class="post_title"><a href="<?php esc_url(the_permalink()); ?>" rel="bookmark" title="
                                    <?php
                                    esc_attr_e('Permanent Link to ', 'hustler');

                                    the_title_attribute()
                                    ?>
                                                          "><?php the_title(); ?></a></h1>
                                <ul class="post_meta">
                                    <li class="posted_by"><span class="glyphicon glyphicon-user"></span><span><?php esc_html_e('Posted by', 'hustler'); ?></span>&nbsp;<?php the_author_posts_link(); ?></li>
                                    <li class="post_date"><span class="glyphicon glyphicon-calendar"></span><span><?php esc_html_e('on', 'hustler'); ?></span>&nbsp;<?php the_time(get_option('date_format')); ?></li>
                                    <li class="post_category"><span class="glyphicon glyphicon-folder-open"></span>&nbsp;<span><?php esc_html_e('in', 'hustler'); ?></span>&nbsp;<?php the_category(', '); ?></li>
                                    <li class="postc_comment">&nbsp;<?php comments_popup_link(esc_html__('No Comments.', 'hustler'), esc_html__('1 Comment.', 'hustler'), esc_html__('% Comments.', 'hustler'), '', ''); ?></li>
                                </ul>
                                <div class="post_content"> 
                                    <?php
                                    if (( 'the_post_thumbnail' ) && ( has_post_thumbnail() )) {
                                        hustler_get_thumbnail(740, 555);
                                    } else {
//                                        if ($img_data <= 12) {
//                                            $permalink = get_permalink();
//                                            echo "<a href='" . esc_url($permalink) . "'><img class='postimg' src='" . esc_url(get_template_directory_uri() . '/inc/demo-prev_img/' . $img_data . '.jpg') . "' width='740' height='555' /></a>";
//                                            $img_data += 1;
//                                        }
                                    }
                                    ?>
                                    <p>
                                        <?php the_excerpt(); ?>
                                    </p>

                                    <?php if (has_tag()) { ?>
                                        <div class="tag">
                                            <?php the_tags(__('Post Tagged with : ', 'hustler'), ', ', ''); ?>
                                        </div>
                                    <?php } ?>
                                    
                                </div>
                            </div>
                            <!--End post-->
                            <?php
                        endwhile;
                        the_posts_navigation(
                                array(
                                    'prev_text' => '<span class="screen-reader-text">' . __('Previous Post', 'hustler') . '</span><span aria-hidden="true" class="nav-previous">' . __('&larr; Previous posts', 'hustler') . '</span>',
                                    'next_text' => '<span class="screen-reader-text">' . __('Next Post', 'hustler') . '</span><span aria-hidden="true" class="nav-next">' . __('Newer posts &rarr;', 'hustler') . '</span> ',
                                )
                        );
                    else :
                        ?>
                        <div class="post">
                            <p>
                                <?php esc_html_e('Sorry, no posts matched your criteria.', 'hustler'); ?>
                            </p>
                        </div>
                    <?php endif; ?>
                    <!--End Loop-->
                    <div class="clear"></div>

                </div>
            </div>
            <div class="col-md-4">
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
