<?php
/**
 * The template for displaying Author pages.
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="content-bar">
                    <?php
                    if (have_posts()) :
                        the_post();
                        ?>
                        <h1 class="page_title"><?php the_archive_title(); ?></h1>
                        <?php
                        /*
                          Queue the first post, that way we know who
                         * the author is when we try to get their name,
                         * URL, description, avatar, etc.
                         *
                         * We reset this later so we can run the loop
                         * properly with a call to rewind_posts().
                         */
                        if (have_posts()) {
                            the_post();
                        }

                        // If a user has filled out their description, show a bio on their entries.
                        if (get_the_author_meta('description')) :
                            ?>
                            <div id="entry-author-info">
                                <div id="author-avatar"> <?php echo esc_html(get_avatar(get_the_author_meta('user_email')), apply_filters('hustler_author_bio_avatar_size', 60)); ?> </div>
                                <!-- #author-avatar -->
                                <div id="author-description">
                                    <h2><?php /* translators: %s - author-description */ printf(esc_html__('About %s', 'hustler'), esc_html(get_the_author())); ?></h2>
                                    <p><?php the_archive_description(); ?></p>
                                </div>
                                <!-- #author-description    -->
                            </div>
                            <!-- #entry-author-info -->
                            <?php
                        endif;
                        /*
                          Since we called the_post() above, we need to
                         * rewind the loop back to the beginning that way
                         * we can run the loop properly, in full.
                         */
                        rewind_posts();
                        /*
                          Run the loop for the author archive page to output the authors posts
                         * If you want to overload this in a child theme then include a file
                         * called loop-author.php and that will be used instead.
                         */

                        get_template_part('template-parts/content');
                        ?>
                        <div class="clear"></div>
                        <nav id="nav-single">
                            <?php
                            the_posts_navigation(
                                    array(
                                        'prev_text' => '<span class="screen-reader-text">' . __('Previous Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('&larr; Previous posts', 'hustler') . '</span>',
                                        'next_text' => '<span class="screen-reader-text">' . __('Next Post', 'hustler') . '</span><span aria-hidden="true" class="nav-subtitle">' . __('Newer posts &rarr;', 'hustler') . '</span> ',
                                    )
                            );
                            ?>
                        </nav>
                    <?php endif; ?>    
                </div>
            </div>
            <div class="col-md-4">
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
