<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package Hustler
 */
get_header();
?>
<div class="clear"></div>
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="content-bar">
                    <?php the_content(); ?>    
                    <h1 class="entry-title">
                        <?php esc_html_e('This is somewhat embarrassing, isn&rsquo;t it?', 'hustler'); ?>
                    </h1>
                    <p>
                        <?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching, or one of the links below, can help.', 'hustler'); ?>
                    </p>
                    <?php
                    get_search_form();
                    the_widget('WP_Widget_Recent_Posts', array('number' => 10), array('widget_id' => '404'));
                    ?>
                    <div class="widget">
                        <h2 class="widgettitle">
                            <?php esc_html_e('Most Used Categories', 'hustler'); ?>
                        </h2>
                        <ul>
                            <?php
                            wp_list_categories(
                                    array(
                                        'orderby' => 'count',
                                        'order' => 'DESC',
                                        'show_count' => 1,
                                        'title_li' => '',
                                        'number' => 10,
                                    )
                            );
                            ?>
                        </ul>
                    </div>
                    <?php
                    /* translators: %1$s: smilie */
                    $archive_content = '<p>' . sprintf(esc_html__('Try looking in the monthly archives. %1$s', 'hustler'), convert_smilies(':)')) . '</p>';
                    the_widget(
                            'WP_Widget_Archives', array(
                        'count' => 0,
                        'dropdown' => 1,
                            ), array('after_title' => '</h2>' . $archive_content)
                    );
                    the_widget('WP_Widget_Tag_Cloud');
                    ?>
                </div>
            </div>
            <div class="col-md-4"> 
                <!--Start Sidebar-->
                <?php get_sidebar(); ?>
                <!--End Sidebar-->
            </div>
        </div>
    </div>

</div>
<?php
get_footer();
