<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hunky Multipurpose
 */
$idd = get_the_ID();
$featured_img_url = get_the_post_thumbnail_url($post->ID, 'hunky-blog-thumb-grid');
?>

<div class="<?php if (is_active_sidebar('sidebar')): ?> col-lg-6 col-md-6 col-12 <?php else : ?> col-lg-4 col-md-6 col-12 <?php endif; ?>   hunky-multipurpose-masonry-item hunky-multipurpose-mg-top-30">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="blog-article-3__card">
            <?php if (has_post_thumbnail()) : ?>
            <div class="blog-article-3__img">
                <a href="<?php the_permalink(); ?>" class="blog_img">
                    <img src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title_attribute(); ?>">
                </a>
                <div class="blog-article-3__head">
                    <ul>
                        <li><?php echo get_the_date(); ?></li>
                        <li><?php echo get_comments_number_text(); ?></li>
                    </ul>
                </div>
            </div>
            <?php endif; ?>
            <div class="blog-article-info">
                <a href="<?php the_permalink(); ?>">
                    <h3><?php the_title(); ?></h3>
                </a>
                <div class="blog-article-3__text">
                    <p><?php echo wp_trim_words(get_the_excerpt(), 16, '...'); ?></p>
                </div>
                <a href="<?php the_permalink(); ?>" class="btn__secondary"><?php esc_html_e('Read more','hunky-multipurpose');?></a>
            </div>
        </div>
	</article><!-- #post-<?php the_ID(); ?> -->
</div>