<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hunky Multipurpose
 */

get_header();
?>

<?php if (get_theme_mod('hunky_multipurpose_page_bc', true)) : ?>
	<section class="breadcrumb hunky-bg-cover">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="breadcrumb__info">
                        <h2> 
                           <?php the_title(); ?>
                        </h2>
                        <?php if (!empty($blog_bc_custom_text)) : ?>
                            <p  class="hunky-breadcrumb__text"><?php echo esc_html($blog_bc_custom_text);?></p>
                        <?php endif;?>
                        <ul>
                            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Home','hunky-multipurpose');?></a></li>
                            <li><?php the_title(); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>


<section class="hunky-multipurpose-page site-page <?php echo hunky_multipurpose_active(); ?>">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="hunky-multipurpose-page__inners">
					<?php
					while (have_posts()) :
						the_post();

						get_template_part('theme-parts/content', 'page');

						// If comments are open or we have at least one comment, load up the comment template.
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
