<?php

new \Kirki\Section(
	'hunky_multipurpose_theme',
	[
		'title'       => esc_html__('Theme Settings', 'hunky-multipurpose'),
		'description' => esc_html__('Customize Global Options.', 'hunky-multipurpose'),
		'panel'       => 'hunky_multipurpose_panel_id',
		'priority'    => 160,
	]
);

new \Kirki\Field\Color(
    [
        'settings'    => 'hunky_multipurpose_primary_color',
        'label'       => esc_html__('Primary Color', 'hunky-multipurpose'),
        'section'     => 'hunky_multipurpose_theme',
        'default'     => '#88e64a', // Default color
        'priority'    => 1,
        'transport'   => 'auto',
        'choices'     => [
            'alpha' => true, // Allow opacity adjustments if needed
        ],
        'output'      => [
            [
                'element'  => ':root', // Use :root to define a CSS variable
                'property' => '--hunky-multipurpose-primary', // Set CSS variable
                'value'    => 'color', // This will allow the color to be applied from the input
            ],
            [
                'element'  => '.hunky-multipurpose-primary', // Target specific elements
                'property' => 'color',
            ],
        ],
    ]
);

new \Kirki\Field\Custom(
    [
        'settings' => 'separator',
        'section'  => 'hunky_multipurpose_theme',
        'default'  => '<hr />', // HTML code for the horizontal line
        'priority' => 3.5, // Adjust priority to position the line between color and typography
    ]
);


// Add a color picker for heading colors
new \Kirki\Field\Color(
    [
        'settings'    => 'hunky_multipurpose_heading_color',
        'label'       => esc_html__('Secondary Color', 'hunky-multipurpose'),
        'section'     => 'hunky_multipurpose_theme',
        'default'     => '#0e0e0e', // Default heading color
        'priority'    => 2,
        'transport'   => 'auto',
        'output'      => [
            [
                'element'  => 'body, h1, h2, h3, h4, h5, h6,.blog-article-info h3', // Target all heading elements
                'property' => 'color',
            ],
        ],
    ]
);

// Add a color picker for paragraph color
new \Kirki\Field\Color(
    [
        'settings'    => 'hunky_multipurpose_paragraph_color',
        'label'       => esc_html__('Paragraph Color', 'hunky-multipurpose'),
        'section'     => 'hunky_multipurpose_theme',
        'default'     => '#0e0e0e', // Default paragraph color
        'priority'    => 3,
        'transport'   => 'auto',
        'output'      => [
            [
                'element'  => 'body p,body .hunky-multipurpose-blog-single p,.blog-article-info p', // Target paragraph elements
                'property' => 'color', // Add !important to the property
            ],
        ],
    ]
);



new \Kirki\Field\Typography(
	[
		'settings'    => 'hunky_multipurpose_typography',
		'label'       => esc_html__('Theme Typography', 'hunky-multipurpose'),
		'section'     => 'hunky_multipurpose_theme',
		'default'     => [
			'font-family'    => 'Poppins',
			'variant'        => '400',
			'font-size'      => '16px',
			'line-height'    => '28px',
			'letter-spacing' => '0',
			'text-transform' => 'none',
		],
		'priority'    => 4, // Adjust priority as needed
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => 'body', // You can target other elements as well
			],
		],
	]
);

