<?php

new \Kirki\Section(
	'hunky_multipurpose_header',
	[
		'title'       => esc_html__('Header Settings', 'hunky-multipurpose'),
		'description' => esc_html__('Customize Header Options.', 'hunky-multipurpose'),
		'panel'       => 'hunky_multipurpose_panel_id',
		'priority'    => 160,
	]
);


new \Kirki\Field\Checkbox_Switch(
	[
		'settings'    => 'show_header_search',
		'label'       => esc_html__('Show Header Search?', 'hunky-multipurpose'),
		'section'     => 'hunky_multipurpose_header',
		'default'     => 'on',
		'choices'     => [
			'on'  => esc_html__('Enable', 'hunky-multipurpose'),
			'off' => esc_html__('Disable', 'hunky-multipurpose'),
		],
		'priority' => 3,
	]
);



new \Kirki\Section(
	'hunky_multipurpose_footer',
	[
		'title'       => esc_html__( 'Footer Settings', 'hunky-multipurpose' ),
		'description' => esc_html__( 'Customize Footer Options.', 'hunky-multipurpose' ),
		'panel'       => 'hunky_multipurpose_panel_id',
		'priority'    => 160,
	]
);

new \Kirki\Field\Repeater(
	[
		'settings' => 'hunky_multipurpose_pages',
		'label'    => esc_html__( 'Footer Page List', 'hunky-multipurpose' ),
		'section'  => 'hunky_multipurpose_footer',
		'priority' => 2,
		'default'  => [
			[
				'link_text'   => esc_html__( 'About Us', 'hunky-multipurpose' ),
				'link_url'    => '#',
				'link_target' => '_self',
				'checkbox'    => false,
			],
		],
		'fields'   => [
			'link_text'   => [
				'type'        => 'text',
				'label'       => esc_html__( 'Link Text', 'hunky-multipurpose' ),
				'description' => esc_html__( 'Description', 'hunky-multipurpose' ),
				'default'     => '',
			],
			'link_url'    => [
				'type'        => 'text',
				'label'       => esc_html__( 'Link URL', 'hunky-multipurpose' ),
				'description' => esc_html__( 'Description', 'hunky-multipurpose' ),
				'default'     => '',
			],
			'link_target' => [
				'type'        => 'select',
				'label'       => esc_html__( 'Link Target', 'hunky-multipurpose' ),
				'description' => esc_html__( 'Description', 'hunky-multipurpose' ),
				'default'     => '_self',
				'choices'     => [
					'_blank' => esc_html__( 'New Window', 'hunky-multipurpose' ),
					'_self'  => esc_html__( 'Same Frame', 'hunky-multipurpose' ),
				],
			],
		],
	]
);
