<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Hunky Multipurpose
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function hunky_multipurpose_body_classes($classes)
{
	// Adds a class of hfeed to non-singular pages.
	if (! is_singular()) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if (! is_active_sidebar('sidebar-1') && ! is_active_sidebar('sidebar-2')) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter('body_class', 'hunky_multipurpose_body_classes');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function hunky_multipurpose_pingback_header()
{
	if (is_singular() && pings_open()) {
		printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
	}
}
add_action('wp_head', 'hunky_multipurpose_pingback_header');



// Dashboard Notice for Hunky Multipurpose Theme
function hunky_multipurpose_display_dashboard_notice() {
    ?>
    <div class="notice notice-info is-dismissible" style="font-size:16px; padding:25px;">
        <strong>
            <?php 
            printf( esc_html__( 'Hey %s 👋 You’re Using Free Version Theme!', 'hunky-multipurpose' ), esc_html( get_bloginfo( 'name' ) ) ); 
            ?>
        </strong>
        <h3 style="margin:15px 0 10px;">
		<?php esc_html_e( 'Get Hunky Pro 🚀 and unlock unlimited features for your website.', 'hunky-multipurpose' ); ?>

        </h3>
        <p style="font-size:16px; margin:0 0 10px;">
			<?php esc_html_e( 'Hunky Pro is built for serious creators — enjoy premium Elementor widgets, pre-built demos, one-click installation, powerful theme options, and more. Includes agency, Marketing, Business & Portfolio layouts with endless customization features.', 'hunky-multipurpose' ); ?>
        </p>
        <p style="font-size:16px; color: #ef644c; font-weight: bold;">
            <?php esc_html_e( 'No limits. No code. Just creative freedom 🚀', 'hunky-multipurpose' ); ?>
        </p>
        <p style="margin:0;">
			<a href="<?php echo esc_url( 'https://yetiwp.com/product/hunky-pro/' ); ?>" class="button button-primary" style="padding:4px 18px; font-size:15px;" target="_blank">
				<?php esc_html_e( 'Buy Pro Version', 'hunky-multipurpose' ); ?>
			</a>
			<a href="<?php echo esc_url( 'https://hunky-pro.yetiwp.com/' ); ?>" class="button button-secondary" style="padding:4px 18px; font-size:15px;" target="_blank">
				<?php esc_html_e( 'View Pro Demo', 'hunky-multipurpose' ); ?>
			</a>
			<a href="<?php echo esc_url( 'https://yetiwp.com/product/hunky-multipurpose/' ); ?>" class="button button-secondary" style="padding:4px 18px; font-size:15px;" target="_blank">
				<?php esc_html_e( 'View Free Version', 'hunky-multipurpose' ); ?>
			</a>
			<a href="<?php echo esc_url( 'https://yetiwp.com/themedoc/hunky-multipurpose/' ); ?>" class="button button-secondary" style="padding:4px 18px; font-size:15px;" target="_blank">
				<?php esc_html_e( 'Install Free Version', 'hunky-multipurpose' ); ?>
			</a>
        </p>
    </div>
    <?php
}
add_action( 'admin_notices', 'hunky_multipurpose_display_dashboard_notice' );


