<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Hunky Multipurpose
 */

$show_header_search = get_theme_mod('show_header_search', 'on');

?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<div id="page" class="site">

		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'hunky-multipurpose'); ?></a>

		<header class="hunky-multipurpose-header site-header">
			<?php if (get_header_image()) : ?>
				<div class="header-image">
					<img src="<?php header_image(); ?>" width="<?php echo absint(get_custom_header()->width); ?>" height="<?php echo absint(get_custom_header()->height); ?>">
				</div>
			<?php endif; ?>
			<div class="container">
				<div class="d-none d-lg-block">
					<div class="row align-items-center justify-between">
						<div class="col-lg-2">
							<div class="hunky-multipurpose-logo">
								<?php if (function_exists('the_custom_logo') && has_custom_logo()) {
									the_custom_logo();
								} else { ?>
									<div class="normal-text">
										<a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html(get_bloginfo('name')); ?></a>
										<?php $hunky_multipurpose_title_description = get_bloginfo('description', 'display'); ?>
										<p class="site-description"><?php echo esc_html($hunky_multipurpose_title_description); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
																	?></p>
									</div>
								<?php } ?>

								<div class="hunky-multipurpose-header__menu">
									<nav id="site-navigation" class="hunky-multipurpose-header__nav navbar navbar-expand-lg" style="display: none;">
										<div class="navbar-collapse">
											<?php
											wp_nav_menu(array(
												'theme_location' => 'menu-1',
												'menu_id'        => 'primary-menu',
												'menu_class'        => 'nav hunky-multipurpose-menu navbar-nav',
											));
											?>
										</div>
									</nav>
								</div>
							</div>
							
						</div>
						<div class="col-lg-10">
							<div class="hunky-multipurpose-header__main-inside">
								<nav class="hunky-multipurpose-header__nav">
									<?php
									wp_nav_menu(array(
										'theme_location' => 'menu-1',
										'menu_id'        => 'primary-menu',
										'menu_class'        => 'main-menu',
									));
									?>
								</nav>

								<div class="header-button">
									<?php if (true == get_theme_mod('show_header_search', 'on')) : ?>
										<a href="javascript:void(0)" data-bs-toggle="offcanvas" data-bs-target="#offcanvasTopSearch" aria-controls="offcanvasTopSearch">
											<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M11 19C15.4183 19 19 15.4183 19 11C19 6.58172 15.4183 3 11 3C6.58172 3 3 6.58172 3 11C3 15.4183 6.58172 19 11 19Z" stroke="#0A0C00" stroke-width="2" stroke-linecap="square"></path>
												<path d="M21.0004 20.9999L16.6504 16.6499" stroke="#0A0C00" stroke-width="2" stroke-linecap="square"></path>
											</svg>
										</a>

										<!-- | header search start | -->
										<div class="header-find offcanvas offcanvas-top" tabindex="-1" id="offcanvasTopSearch"
											aria-labelledby="offcanvasTopSearch">
											<div class="offcanvas-body">
												<div class="header-find__box">
													<?php get_search_form(); ?>
												</div>									
												<button type="button" class=" pw-close-btn pw-close-btn--search" data-bs-dismiss="offcanvas" aria-label="<?php esc_attr_e('Close', 'hunky-multipurpose'); ?>"></button>
											</div>
										</div>
										<!-- | header search end | -->
									<?php endif; ?>
					
								</div>	
								
							</div>
										
						</div>
					</div>
				</div>

				<nav class="mobile-menu d-block d-lg-none">
					<div class="mobile-header">
						<div class="header-logo hunky-multipurpose-logo">
							<?php if (function_exists('the_custom_logo') && has_custom_logo()) {
								the_custom_logo();
							} else { ?>
								<div class="normal-text">
									<a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html(get_bloginfo('name')); ?></a>
									<?php $hunky_multipurpose_title_description = get_bloginfo('description', 'display'); ?>
									<p class="site-description"><?php echo esc_html($hunky_multipurpose_title_description); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
									?></p>
								</div>
							<?php } ?>
						</div>
						<button
							type="button"
							class="header__hamburger-2 d-lg-none offcanvas-open-btn"
							data-bs-toggle="offcanvas"
							data-bs-target="#offcanvasWithBothOptions"
							aria-controls="offcanvasWithBothOptions">
							<span></span>
							<span></span>
							<span></span>
						</button>
					</div>

					<div class="mobile-menu-popup offcanvas offcanvas-end" data-bs-scroll="true" tabindex="-1" id="offcanvasWithBothOptions">
						<div class="offcanvas-header">
							<button class="offcanvas__close-btn offcanvas-close-btn" data-bs-dismiss="offcanvas" aria-label="<?php esc_attr_e('Close', 'hunky-multipurpose'); ?>">
								<svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
									<path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
								</svg>
							</button>
						</div>
						<div class="offcanvas-body">
							<div class="mobile-menu-section">
								<?php
								wp_nav_menu(array(
									'theme_location' => 'menu-1',
									'menu_id'        => 'mobile-menu',
									'menu_class'        => 'menu-list',
								));
								?>
							</div>
						</div>
					</div>
				</nav>
			</div>

		</header>

		<div id="primary" class="hunky-multipurpose-section-main">