<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Hunky Multipurpose
 */

// Default values for repeater_setting theme mod.
$defaults = [
	[
		'link_text' => esc_html__('About Us', 'hunky-multipurpose'),
		'link_url' => '#',
		'link_target' => '_self',
	],
];
// Retrieve the repeater field settings
$hunky_multipurpose_pages = get_theme_mod('hunky_multipurpose_pages', $defaults);

?>
</div>

<footer class="hunky-footer">
	<div class="container">
		<div class="hunky-footer-main">
			<div class="row align-items-center">
				<?php if (is_active_sidebar('hunky-multipurpose-footer-1')) : ?>
					<div class="col-lg-6 col-md-6 col-12">
						<?php dynamic_sidebar('hunky-multipurpose-footer-1'); ?>
					</div>
				<?php endif; ?>

				<?php if (is_active_sidebar('hunky-multipurpose-footer-2')) : ?>
					<div class="col-lg-6 col-md-6 col-12">
						<?php dynamic_sidebar('hunky-multipurpose-footer-2'); ?>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>

	<div class="hunky-footer-copyright">
		<div class="container">
			<div class="row gy-2">
				<div class="col-md-6">
					<div class="copyright-text">
					<p class="copyright-detail">
						<?php 
						esc_html_e('&copy;', 'hunky-multipurpose'); 
						?> 
						<?php echo esc_html(date_i18n(__('Y', 'hunky-multipurpose'))); ?>
						<a class="hunky-multipurpose-footer__url" href="<?php echo esc_url(home_url('/')); ?>">
							<?php echo esc_html(get_bloginfo('name')); ?>
						</a> .
					
						<?php esc_html_e('Theme Provided By', 'hunky-multipurpose'); ?> 
						<a href="<?php echo esc_url('https://yetiwp.com/product/hunky-multipurpose'); ?>" target="_blank" rel="noopener noreferrer">
							<?php esc_html_e('Yetiwp', 'hunky-multipurpose'); ?>
						</a>
					</p>
					</div>
				</div>
				<div class="col-md-6">
					<div class="copyright-list">
						<ul class="footer-menu-list">
							<?php foreach ($hunky_multipurpose_pages as $hunky_multipurpose_page) : ?>
								<li><a href="<?php echo esc_url($hunky_multipurpose_page['link_url']); ?>" target="<?php echo esc_attr($hunky_multipurpose_page['link_target']); ?>"><?php echo esc_html($hunky_multipurpose_page['link_text']); ?></a></li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer>

</div><!-- End Page -->

<?php wp_footer(); ?>

</body>

</html>