<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hunky Multipurpose
 */

get_header();
?>

	<?php if(get_theme_mod('hunky_multipurpose_archive_bc', true)) : ?>
		<section class="breadcrumb hunky-bg-cover">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-lg-6">
						<div class="breadcrumb__info">
							<?php
								the_archive_title( '<h2>', '</h2>' );
								the_archive_description( '<p class="hunky-breadcrumb__text">', '</p>' );
							?>
							<ul>
								<li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__('Home', 'hunky-multipurpose'); ?></a></li>
								<li><?php single_cat_title(); ?></li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>
	
	<section class="hunky-multipurpose-blog-section site-archive">
		<div class="container">
			<div class="row">
				<div class="<?php if(is_active_sidebar('sidebar')): ?> col-lg-8 hunky-multipurpose-main-area__with-side <?php else :?> col-12 <?php endif; ?>">
					<div class="row hunky-multipurpose-masonry">
						<?php if ( have_posts() ) : ?>
							<?php
								/* Start the Loop */
								while ( have_posts() ) :
								the_post();

								/*
								 * Include the Post-Type-specific template for the content.
								 * If you want to override this in a child theme, then include a file
								 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
								 */
								get_template_part( 'theme-parts/content', get_post_type() );

							endwhile;

							else :
							get_template_part( 'theme-parts/content', 'none' );

							endif;
						?>
					</div>
					<div class="row">
						<div class="col-12">
							<div class="pagination-main">
								<?php if (function_exists("hunky_multipurpose_pagination")) :?>
									<?php hunky_multipurpose_pagination(); ?>
								<?php endif;?>
							</div>
						</div>
					</div>	
				</div>
				<?php if(is_active_sidebar('sidebar')): ?>
				<div class="col-lg-4 col-12 hunky-multipurpose-main-area__sidebar">
					<div class="hunky-multipurpose-sidebar hunky-multipurpose-sidebar__right">
						<?php get_sidebar(); ?>
					</div>
				</div>
				<?php endif;?>
			</div>
		</div>
	</section>

<?php
get_footer();
