<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Hunky Multipurpose
 */

get_header();
?>

	<section class="breadcrumb hunky-bg-cover">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="breadcrumb__info">
                        <h2> 
                            <?php  esc_html_e('Page Not Found', 'hunky-multipurpose'); ?>
                        </h2>
                        <ul>
                            <li><a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__('Home', 'hunky-multipurpose'); ?></a></li>
                            <li><?php echo esc_html__('Blog', 'hunky-multipurpose'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

     <section class="not-found">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6 col-md-10">
                    <div class="not-found__info">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/404-image.png' ); ?>" alt="<?php esc_attr_e( 'Error 404 Image', 'hunky-multipurpose' ); ?>">
                        <h3><?php esc_html_e('Look Like You’re Lost', 'hunky-multipurpose'); ?></h3>
                        <p><?php esc_html_e('Sorry, the page you are looking for could not be found', 'hunky-multipurpose'); ?></p>
                        <a href="<?php echo esc_url(home_url('/')); ?>" class="btn__primary btn__primary--2" data-btn-name="Back To Home"><?php esc_html_e('Back to Home', 'hunky-multipurpose'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php
get_footer();
