<?php

define( 'HSTORE_THEME_VERSION', '16.7' );

function hstore_css() {
    $parent_style = 'specia-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'hstore-main', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('hstore-default',get_stylesheet_directory_uri() .'/css/colors/default.css');
	wp_dequeue_style('specia-default');
	
	wp_enqueue_style('hstore-media-query',get_stylesheet_directory_uri() .'/css/media-query.css');
	wp_dequeue_style('specia-media-query');
	
	wp_enqueue_script('hstore-custom-js',get_stylesheet_directory_uri() .'/js/custom.js');
}
add_action( 'wp_enqueue_scripts', 'hstore_css',999);


require_once( get_stylesheet_directory() . '/inc/customize/hstore-header-section.php');
require_once( get_stylesheet_directory() . '/inc/customize/hstore-product.php');
require_once( get_stylesheet_directory() . '/inc/customize/hstore-premium.php');

/**
 * Remove Customize Panel from parent theme
 */
function hstore_remove_parent_setting( $wp_customize ) {
	$wp_customize->remove_panel('service_panel');	
}
add_action( 'customize_register', 'hstore_remove_parent_setting',99 );

/**
 * Import Options From Specia Theme
 *
 */
function hstore_parent_theme_options() {
	$specia_mods = get_option( 'theme_mods_specia' );
	if ( ! empty( $specia_mods ) ) {
		foreach ( $specia_mods as $specia_mod_k => $specia_mod_v ) {
			set_theme_mod( $specia_mod_k, $specia_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'hstore_parent_theme_options' );