<?php

add_action( 'admin_menu', 'hr_management_gettingstarted' );
function hr_management_gettingstarted() {
	add_theme_page( esc_html__('Begin Installation', 'hr-management'), esc_html__('Begin Installation', 'hr-management'), 'edit_theme_options', 'hr-management-guide-page', 'hr_management_guide');
}

if ( ! defined( 'HR_MANAGEMENT_SUPPORT' ) ) {
define('HR_MANAGEMENT_SUPPORT',__('https://wordpress.org/support/theme/hr-management/','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_REVIEW' ) ) {
define('HR_MANAGEMENT_REVIEW',__('https://wordpress.org/support/theme/hr-management/reviews/','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_LIVE_DEMO' ) ) {
define('HR_MANAGEMENT_LIVE_DEMO',__('https://trial.ovationthemes.com/hr-management/','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_BUY_PRO' ) ) {
define('HR_MANAGEMENT_BUY_PRO',__('https://www.ovationthemes.com/products/human-resource-wordpress-theme','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_PRO_DOC' ) ) {
define('HR_MANAGEMENT_PRO_DOC',__('https://trial.ovationthemes.com/docs/hr-management-doc/','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_FREE_DOC' ) ) {
define('HR_MANAGEMENT_FREE_DOC',__('https://trial.ovationthemes.com/docs/hr-management-free-doc/','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_THEME_NAME' ) ) {
define('HR_MANAGEMENT_THEME_NAME',__('Premium HR Management Theme','hr-management'));
}
if ( ! defined( 'HR_MANAGEMENT_BUNDLE_LINK' ) ) {
define('HR_MANAGEMENT_BUNDLE_LINK',__('https://www.ovationthemes.com/products/wordpress-bundle','hr-management'));
}
/**
 * Theme Info Page
 */
function hr_management_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( '' ); ?>

	<div class="getting-started__header">
		<div class="header-box-left">
			<h2><?php echo esc_html( $theme ); ?></h2>
			<p><?php esc_html_e('Version: ', 'hr-management'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
		<div class="header-box-right">
			<div class="btn_box">
				<a class="button-primary" href="<?php echo esc_url( HR_MANAGEMENT_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'hr-management'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( HR_MANAGEMENT_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'hr-management'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( HR_MANAGEMENT_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'hr-management'); ?></a>
			</div>
		</div>
	</div>

	<div class="wrap getting-started">
		<div class="box-container">
			<div class="box-left-main">
				<div class="leftbox">
					<h3><?php esc_html_e('Documentation','hr-management'); ?></h3>
					<p><?php $theme = wp_get_theme(); 
						echo wp_kses_post( apply_filters( 'description', esc_html( $theme->get( 'Description' ) ) ) );
					?></p>

					<h4><?php esc_html_e('Edit Your Site','hr-management'); ?></h4>
					<p><?php esc_html_e('Now create your website with easy drag and drop powered by gutenburg.','hr-management'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site','hr-management'); ?></a>

					<h4><?php esc_html_e('Visit Your Site','hr-management'); ?></h4>
					<p><?php esc_html_e('To check your website click here','hr-management'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site','hr-management'); ?></a>

					<h4><?php esc_html_e('Theme Documentation','hr-management'); ?></h4>
					<p><?php esc_html_e('Check the theme documentation to easily set up your website.','hr-management'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( HR_MANAGEMENT_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','hr-management'); ?></a>
				</div>
       	</div>
			<div class="box-right-main">
				<h3><?php echo esc_html(HR_MANAGEMENT_THEME_NAME); ?></h3>
				<img class="hr_management_img_responsive" style="width: 100%;" src="<?php echo esc_url( $theme->get_screenshot() ); ?>" />
				<div class="pro-links">
					<div class="pro-links-inner">
						<a class="button-primary livedemo" href="<?php echo esc_url( HR_MANAGEMENT_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'hr-management'); ?></a>
						<a class="button-primary buynow" href="<?php echo esc_url( HR_MANAGEMENT_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'hr-management'); ?></a>
						<a class="button-primary docs" href="<?php echo esc_url( HR_MANAGEMENT_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'hr-management'); ?></a>
					</div>
						<a class="button-primary bundle-btn" href="<?php echo esc_url( HR_MANAGEMENT_BUNDLE_LINK ); ?>" target="_blank"><?php esc_html_e('WordPress Theme Bundle (125+ Themes at Just $99)', 'hr-management'); ?></a>
				</div>
				<ul style="padding-top:10px">
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'hr-management');?> </li>                 
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'hr-management');?> </li>
					<li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'hr-management');?> </li>
               <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'hr-management');?> </li>
            </ul>
        	</div>
		</div>
	</div>

<?php }?>