<?php
/**
 * HR Management: Customizer
 *
 * @subpackage HR Management
 * @since 1.0
 */

function hr_management_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/inc/customizer/customizer.css');

	// Pro Section
 	$wp_customize->add_section('hr_management_pro', array(
        'title'    => __('HR MANAGEMENT PREMIUM', 'hr-management'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('hr_management_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new HR_Management_Pro_Control($wp_customize, 'hr_management_pro', array(
        'label'    => __('HR MANAGEMENT PREMIUM', 'hr-management'),
        'section'  => 'hr_management_pro',
        'settings' => 'hr_management_pro',
        'priority' => 1,
    )));
}
add_action( 'customize_register', 'hr_management_customize_register' );


define('HR_MANAGEMENT_PRO_LINK',__('https://www.ovationthemes.com/products/human-resource-wordpress-theme','hr-management'));

define('HR_MANAGEMENT_BUNDLE_BTN',__('https://www.ovationthemes.com/products/wordpress-bundle','hr-management'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('HR_Management_Pro_Control')):
    class HR_Management_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( HR_MANAGEMENT_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE HR MANAGEMENT PREMIUM','hr-management');?> </a>
	        </div>
            <div class="col-md">
                <img class="hr_management_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
                <ul style="padding-top:10px">
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'hr-management');?> </li>                 
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'hr-management');?> </li>
                    <li class="upsell-hr_management"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'hr-management');?> </li>
                </ul>
        	</div>
            <div class="col-md upsell-btn upsell-btn-bottom">
                <a href="<?php echo esc_url( HR_MANAGEMENT_BUNDLE_BTN ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('WP Theme Bundle (125+ Themes)','hr-management');?> </a>
            </div>
        </label>
    <?php } }
endif;