<?php 

function hr_management_add_admin_menu() {
    add_menu_page(
        'Theme Settings', // Page title
        'Theme Settings', // Menu title
        'manage_options', // Capability
        'hr-management-theme-settings', // Menu slug
        'hr_management_settings_page' // Function to display the page
    );
}
add_action( 'admin_menu', 'hr_management_add_admin_menu' );

function hr_management_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Theme Settings', 'hr-management' ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'hr_management_settings_group' );
            do_settings_sections( 'hr-management-theme-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function hr_management_register_settings() {
    register_setting( 'hr_management_settings_group', 'hr_management_enable_animations' );

    add_settings_section(
        'hr_management_settings_section',
        __( 'Animation Settings', 'hr-management' ),
        null,
        'hr-management-theme-settings'
    );

    add_settings_field(
        'hr_management_enable_animations',
        __( 'Enable Animations', 'hr-management' ),
        'hr_management_enable_animations_callback',
        'hr-management-theme-settings',
        'hr_management_settings_section'
    );
}
add_action( 'admin_init', 'hr_management_register_settings' );

function hr_management_enable_animations_callback() {
    $checked = get_option( 'hr_management_enable_animations', true );
    ?>
    <input type="checkbox" name="hr_management_enable_animations" value="1" <?php checked( 1, $checked ); ?> />
    <?php
}

