<?php
/**
 * HR Management: Block Patterns
 *
 * @since HR Management 1.0
 */

/**
 * Registers block patterns and categories.
 *
 * @since HR Management 1.0
 *
 * @return void
 */
function hr_management_register_block_patterns() {
	$hr_management_block_pattern_categories = array(
		'hr-management'    => array( 'label' => __( 'HR Management', 'hr-management' ) ),
	);

	$hr_management_block_pattern_categories = apply_filters( 'hr_management_block_pattern_categories', $hr_management_block_pattern_categories );

	foreach ( $hr_management_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'hr_management_register_block_patterns', 9 );
