<?php 
/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function howbuji_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'howbuji' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'howbuji_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function howbuji_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'howbuji' ),
            'off'       => esc_html__( 'Disable', 'howbuji' )
        );
        return apply_filters( 'howbuji_switch_options', $arr );
    }
endif;

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function howbuji_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'howbuji' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}
if ( ! function_exists( 'howbuji_get_woo_product' ) ) {
    /**
     * Get product.
     */
    function howbuji_get_woo_product() {
        $args = array(
            'posts_per_page' => -1,
        );
         
        $choices = array( '' => esc_html__( '--Select--', 'howbuji' ) );
        $products = wc_get_products( $args );
        foreach ( $products as $product ) {
            $id = $product->get_id();
            $title = $product->get_name();
            $choices[ $id ] = $title;
        }
        return $choices;
    }
}




 /**
 * Get an array of google fonts.
 * 
 */
function howbuji_font_choices() {
    $font_family_arr = array();
    $font_family_arr[''] = esc_html__( '--Default--', 'howbuji' );

    // Make the request
    $request = wp_remote_get( get_theme_file_uri( 'assets/fonts/webfonts.json' ) );

    if( is_wp_error( $request ) ) {
        return false; // Bail early
    }
    // Retrieve the data
    $body = wp_remote_retrieve_body( $request );
    $data = json_decode( $body );
    if ( ! empty( $data ) ) {
        foreach ( $data->items as $items => $fonts ) {
            $family_str_arr = explode( ' ', $fonts->family );
            $family_value = implode( '-', array_map( 'strtolower', $family_str_arr ) );
            $font_family_arr[ $family_value ] = $fonts->family;
        }
    }

    return apply_filters( 'howbuji_font_choices', $font_family_arr );
}

if ( ! function_exists( 'howbuji_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'header-font-1'   => esc_html__( 'Raleway', 'howbuji' ),
            'header-font-2'   => esc_html__( 'Poppins', 'howbuji' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'howbuji' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'howbuji' ),
            'header-font-5'   => esc_html__( 'Lato', 'howbuji' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'header-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'header-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'header-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'howbuji' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'howbuji' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'howbuji' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'howbuji' ),
            'header-font-21'   => esc_html__( 'Courgette', 'howbuji' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'howbuji' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'howbuji' ),
            'header-font-24'   => esc_html__( 'Righteous', 'howbuji' ),
            'header-font-25'   => esc_html__( 'Dosis', 'howbuji' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'howbuji' ),
            'header-font-27'   => esc_html__( 'Faster one', 'howbuji' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'howbuji' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'howbuji' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'howbuji' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'body-font-1'     => esc_html__( 'Raleway', 'howbuji' ),
            'body-font-2'     => esc_html__( 'Poppins', 'howbuji' ),
            'body-font-3'     => esc_html__( 'Roboto', 'howbuji' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'howbuji' ),
            'body-font-5'     => esc_html__( 'Lato', 'howbuji' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'body-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'body-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'body-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'howbuji' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'howbuji_archive_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_archive_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'header-font-1'   => esc_html__( 'Raleway', 'howbuji' ),
            'header-font-2'   => esc_html__( 'Poppins', 'howbuji' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'howbuji' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'howbuji' ),
            'header-font-5'   => esc_html__( 'Lato', 'howbuji' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'header-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'header-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'header-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'howbuji' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'howbuji' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'howbuji' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'howbuji' ),
            'header-font-21'   => esc_html__( 'Courgette', 'howbuji' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'howbuji' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'howbuji' ),
            'header-font-24'   => esc_html__( 'Righteous', 'howbuji' ),
            'header-font-25'   => esc_html__( 'Dosis', 'howbuji' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'howbuji' ),
            'header-font-27'   => esc_html__( 'Faster one', 'howbuji' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'howbuji' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'howbuji' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'howbuji' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_archive_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_archive_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_archive_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'body-font-1'     => esc_html__( 'Raleway', 'howbuji' ),
            'body-font-2'     => esc_html__( 'Poppins', 'howbuji' ),
            'body-font-3'     => esc_html__( 'Roboto', 'howbuji' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'howbuji' ),
            'body-font-5'     => esc_html__( 'Lato', 'howbuji' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'body-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'body-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'body-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'howbuji' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_archive_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_page_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_page_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'header-font-1'   => esc_html__( 'Raleway', 'howbuji' ),
            'header-font-2'   => esc_html__( 'Poppins', 'howbuji' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'howbuji' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'howbuji' ),
            'header-font-5'   => esc_html__( 'Lato', 'howbuji' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'header-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'header-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'header-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'howbuji' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'howbuji' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'howbuji' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'howbuji' ),
            'header-font-21'   => esc_html__( 'Courgette', 'howbuji' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'howbuji' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'howbuji' ),
            'header-font-24'   => esc_html__( 'Righteous', 'howbuji' ),
            'header-font-25'   => esc_html__( 'Dosis', 'howbuji' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'howbuji' ),
            'header-font-27'   => esc_html__( 'Faster one', 'howbuji' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'howbuji' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'howbuji' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'howbuji' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_page_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_page_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_page_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'body-font-1'     => esc_html__( 'Raleway', 'howbuji' ),
            'body-font-2'     => esc_html__( 'Poppins', 'howbuji' ),
            'body-font-3'     => esc_html__( 'Roboto', 'howbuji' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'howbuji' ),
            'body-font-5'     => esc_html__( 'Lato', 'howbuji' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'body-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'body-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'body-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'howbuji' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_page_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_post_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_post_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'header-font-1'   => esc_html__( 'Raleway', 'howbuji' ),
            'header-font-2'   => esc_html__( 'Poppins', 'howbuji' ),
            'header-font-3'   => esc_html__( 'Montserrat', 'howbuji' ),
            'header-font-4'   => esc_html__( 'Open Sans', 'howbuji' ),
            'header-font-5'   => esc_html__( 'Lato', 'howbuji' ),
            'header-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'header-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'header-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'header-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'header-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'header-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'header-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'header-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'header-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'header-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'header-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'header-font-17'   => esc_html__( 'Henny Penny', 'howbuji' ),
            'header-font-18'   => esc_html__( 'Orbitron' , 'howbuji' ),
            'header-font-19'   => esc_html__( 'Marck Script', 'howbuji' ),
            'header-font-20'   => esc_html__( 'Kaushan Script', 'howbuji' ),
            'header-font-21'   => esc_html__( 'Courgette', 'howbuji' ),
            'header-font-22'   => esc_html__( 'Rajdhani', 'howbuji' ),
            'header-font-23'   => esc_html__( 'Bad Script', 'howbuji' ),
            'header-font-24'   => esc_html__( 'Righteous', 'howbuji' ),
            'header-font-25'   => esc_html__( 'Dosis', 'howbuji' ),
            'header-font-26'   => esc_html__( 'Cinzel Decorative', 'howbuji' ),
            'header-font-27'   => esc_html__( 'Faster one', 'howbuji' ),
            'header-font-28'   => esc_html__( 'Tangerine', 'howbuji' ),
            'header-font-29'   => esc_html__( 'Fredericka the Great', 'howbuji' ),
            'header-font-30'   => esc_html__( 'Shadows Into Light', 'howbuji' ),
            'header-font-31'   => esc_html__( 'Gloria Hallelujah', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_post_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_post_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_post_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'body-font-1'     => esc_html__( 'Raleway', 'howbuji' ),
            'body-font-2'     => esc_html__( 'Poppins', 'howbuji' ),
            'body-font-3'     => esc_html__( 'Roboto', 'howbuji' ),
            'body-font-4'     => esc_html__( 'Open Sans', 'howbuji' ),
            'body-font-5'     => esc_html__( 'Lato', 'howbuji' ),
            'body-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'body-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'body-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'body-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'body-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'body-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'body-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'body-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'body-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'body-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'body-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'body-font-17'   => esc_html__( 'Dancing Script ', 'howbuji' ),
            'body-font-18'   => esc_html__( 'Rajdhani', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_post_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'howbuji_site_title_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_site_title_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'site-font-1'   => esc_html__( 'Raleway', 'howbuji' ),
            'site-font-2'   => esc_html__( 'Poppins', 'howbuji' ),
            'site-font-3'   => esc_html__( 'Montserrat', 'howbuji' ),
            'site-font-4'   => esc_html__( 'Open Sans', 'howbuji' ),
            'site-font-5'   => esc_html__( 'Lato', 'howbuji' ),
            'site-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'site-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'site-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'site-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'site-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'site-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'site-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'site-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'site-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'site-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'site-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'site-font-17'   => esc_html__( 'Henny Penny', 'howbuji' ),
            'site-font-18'   => esc_html__( 'Orbitron' , 'howbuji' ),
            'site-font-19'   => esc_html__( 'Marck Script', 'howbuji' ),
            'site-font-20'   => esc_html__( 'Kaushan Script', 'howbuji' ),
            'site-font-21'   => esc_html__( 'Courgette', 'howbuji' ),
            'site-font-22'   => esc_html__( 'Rajdhani', 'howbuji' ),
            'site-font-23'   => esc_html__( 'Bad Script', 'howbuji' ),
            'site-font-24'   => esc_html__( 'Righteous', 'howbuji' ),
            'site-font-25'   => esc_html__( 'Dosis', 'howbuji' ),
            'site-font-26'   => esc_html__( 'Cinzel Decorative', 'howbuji' ),
            'site-font-27'   => esc_html__( 'Faster one', 'howbuji' ),
            'site-font-28'   => esc_html__( 'Tangerine', 'howbuji' ),
            'site-font-29'   => esc_html__( 'Fredericka the Great', 'howbuji' ),
            'site-font-30'   => esc_html__( 'Shadows Into Light', 'howbuji' ),
            'site-font-31'   => esc_html__( 'Gloria Hallelujah', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_site_title_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'howbuji_site_tagline_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function howbuji_site_tagline_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'howbuji' ),
            'tagline-font-1'     => esc_html__( 'Raleway', 'howbuji' ),
            'tagline-font-2'     => esc_html__( 'Poppins', 'howbuji' ),
            'tagline-font-3'     => esc_html__( 'Roboto', 'howbuji' ),
            'tagline-font-4'     => esc_html__( 'Open Sans', 'howbuji' ),
            'tagline-font-5'     => esc_html__( 'Lato', 'howbuji' ),
            'tagline-font-6'   => esc_html__( 'Ubuntu', 'howbuji' ),
            'tagline-font-7'   => esc_html__( 'Playfair Display', 'howbuji' ),
            'tagline-font-8'   => esc_html__( 'Lora', 'howbuji' ),
            'tagline-font-9'   => esc_html__( 'Titillium Web', 'howbuji' ),
            'tagline-font-10'   => esc_html__( 'Muli', 'howbuji' ),
            'tagline-font-11'   => esc_html__( 'Oxygen', 'howbuji' ),
            'tagline-font-12'   => esc_html__( 'Nunito Sans', 'howbuji' ),
            'tagline-font-13'   => esc_html__( 'Maven Pro', 'howbuji' ),
            'tagline-font-14'   => esc_html__( 'Cairo', 'howbuji' ),
            'tagline-font-15'   => esc_html__( 'Philosopher', 'howbuji' ),
            'tagline-font-16'   => esc_html__( 'Quicksand', 'howbuji' ),
            'tagline-font-17'   => esc_html__( 'Dancing Script ', 'howbuji' ),
            'tagline-font-18'   => esc_html__( 'Rajdhani', 'howbuji' ),
        );

        $output = apply_filters( 'howbuji_site_tagline_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

 ?>