jQuery(document).ready(function($) {

/*------------------------------------------------
            DECLARATIONS
------------------------------------------------*/
    var loader                  = $('#loader');
    var loader_container        = $('#preloader');
    var scroll = $(window).scrollTop();  
    var scrollup = $('.backtotop');
    var menu_toggle = $('.menu-toggle');
    var nav_menu = $('.main-navigation ul.nav-menu');
    var featured_slider = $('.featured-slider-wrapper');
    var slider_widget = $('.featured-slider .slider-posts');
    var slider_slider = $('.slider-wrapper');
    var highlights_slider = $('.highlights-wrapper');
    var hero_slider = $('.hero-slider');
    var project_slider = $('.project-slider');
    var client_slider = $('.client-slider');
    var catlist_slider = $('.catlist-slider');
    var trending_slider      = $('.trending-slider');
    var posts_height = $('.blog-posts-wrapper article .post-item');
    var masonry_gallery = $('.grid');
    var portfolio_gallery = $('.portfolio-grid');
    var testimonial_slider    = $('.default-testimonial');
    var modern_testimonial_slider    = $('.modern-testimonial');
    var naturegallery_slider    = $('.naturegallery-slider');
    var naturefeatured_slider    = $('.naturefeatured-slider');

/* -----------------------------------------
    Preloader
    ----------------------------------------- */
    loader_container.delay(1000).fadeOut();
    loader.delay(1000).fadeOut("slow");

/*------------------------------------------------
            BACK TO TOP
------------------------------------------------*/

    $(window).scroll(function() {
        if ($(this).scrollTop() > 1) {
            scrollup.css({bottom:"50px"});
        } 
        else {
            scrollup.css({bottom:"-100px"});
        }
    });

    scrollup.click(function() {
        $('html, body').animate({scrollTop: '0px'}, 800);
        return false;
    });

/*------------------------------------------------
            MAIN NAVIGATION
------------------------------------------------*/
    $('#top-bar > button').click(function(){
        $('#top-bar .wrapper').slideToggle();
        $('#top-bar').toggleClass('topbar-menu-active');
    });
   
    menu_toggle.click(function(){
        $(this).toggleClass('active');
        nav_menu.slideToggle();
        $('body').toggleClass('menu-toggled');
        $('button.dropdown-toggle').removeClass('active');
        $('#masthead').find('.sub-menu').slideUp();
    });

    $('.main-navigation .nav-menu .menu-item-has-children > a').after( $('<button class="dropdown-toggle"><i class="fa fa-angle-down"></i></button>') );

    $('button.dropdown-toggle').click(function() {
        $(this).toggleClass('active');
       $(this).parent().find('.sub-menu').first().slideDown();
    });

     $(window).scroll(function() {
        if ($(this).scrollTop() > 1) {
            $('.menu-sticky #masthead').addClass('nav-shrink'); 
        }
        else {
            $('.menu-sticky #masthead').removeClass('nav-shrink');
        }
    });

    // Keyboard Navigation
    if( $(window).width() < 1024 ) {
        nav_menu.find("li").last().bind( 'keydown', function(e) {
            if( !e.shiftKey && e.which === 9 ) {
                e.preventDefault();
                $('#masthead').find('.menu-toggle').focus();
            }
        });

        $('button.dropdown-toggle').focus(function() {
            $(this).addClass('active');
            $(this).parent().find('.sub-menu').first().slideDown();

            if( $('button.dropdown-toggle').hasClass('active') ) {
                $(this).addClass('active');
                $(this).parent().find('.sub-menu').first().slideDown();
            }
        });

    }
    else {
        nav_menu.find("li").unbind('keydown');
    }

    $(window).resize(function() {
        if( $(window).width() < 1024 ) {
            nav_menu.find("li").last().bind( 'keydown', function(e) {
                if( !e.shiftKey && e.which === 9 ) {
                    e.preventDefault();
                    $('#masthead').find('.menu-toggle').focus();
                }
            });

            $('button.dropdown-toggle').focus(function() {
                $(this).addClass('active');
                $(this).parent().find('.sub-menu').first().slideDown();

                if( $('button.dropdown-toggle').hasClass('active') ) {
                    $(this).addClass('active');
                    $(this).parent().find('.sub-menu').first().slideDown();
                }
            });

        }
        else {
            nav_menu.find("li").unbind('keydown');
        }
    });

    // Shift + Tab Key Keyboard Navigation
    menu_toggle.on('keydown', function (e) {
        var tabKey    = e.keyCode === 9;
        var shiftKey  = e.shiftKey;

        if( menu_toggle.hasClass('active') ) {
            if ( shiftKey && tabKey ) {
                e.preventDefault();
                nav_menu.find("li:last-child > a").focus();
                nav_menu.find("li").last().bind( 'keydown', function(e) {
                    if( !e.shiftKey && e.which === 9 ) {
                        e.preventDefault();
                        $('#masthead').find('.menu-toggle').focus();
                    }
                });
            };
        }
    });

    if( $(window).width() < 1024 ) {
        $( '#top-bar' ).find('li').last().bind( 'keydown', function(e) {
            if( e.which === 9 ) {
                e.preventDefault();
                $('#top-bar').find('button').focus();
            }
        });
    }
    else {
        $( '#top-bar' ).find('li').unbind('keydown');
    }
    $(window).resize(function() {
        if( $(window).width() < 1024 ) {
            $( '#top-bar li' ).find('li').bind( 'keydown', function(e) {
                if( e.which === 9 ) {
                    e.preventDefault();
                    $('#top-bar').find('button').focus();
                }
            });
        }
        else {
            $( '#top-bar li' ).find('li').unbind('keydown');
        }
    });
/* -----------------------------------------
Tabs
----------------------------------------- */
$('.post-tabs-wrapper').each(function(index) {
    $(this).find('.post-tab-container:not(:first-child)').hide();
    $(this).find('.post-tabs li:not(:first-child) a').addClass('inactive');
});
$('.post-tabs li a').click(function() {
    var t = $(this).attr('href');
    $(this).closest('.post-tabs-wrapper').find('.post-tabs li a').addClass('inactive');
    $(this).removeClass('inactive');
    $(this).closest('.post-tabs-wrapper').find('.post-tab-container').hide();
    $(this).closest('.post-tabs-wrapper').find(t).fadeIn('slow');
    return false;
});

/*------------------------------------------------
            SLICK SLIDER
------------------------------------------------*/
    featured_slider.slick({
        responsive: [
    {
        breakpoint: 992,
        settings: {
            slidesToShow: 1
        }
    },
    {
        breakpoint: 767,
        settings: {
            slidesToShow: 1
        }
    }
    ]
    });

    
    $('.home-five .slider-wrapper').slick({
        responsive: [
        {
            breakpoint: 1200,
            settings: {
                slidesToShow: 2
            }
        },
        {
            breakpoint: 767,
            settings: {
                slidesToShow: 1,
                arrows: false
            }
        }
        ]
    });

    $('.gallery-slider').slick({
        asNavFor: '.gallery-slider-nav'
    });

$('.slider-posts-widget .slider-posts').slick();
$('.home-main .slider-wrapper').slick({
  centerMode: true,
  centerPadding: '400px',
  slidesToShow: 1,
  responsive: [
    {
      breakpoint: 1400,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '280px',
        slidesToShow: 1
      }
    },
    {
      breakpoint: 1200,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '180px',
        slidesToShow: 1
      }
    },
    {
      breakpoint: 992,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '0px',
        slidesToShow: 1
      }
    },
    {
      breakpoint: 480,
      settings: {
        arrows: false,
        centerMode: true,
        centerPadding: '0px',
        slidesToShow: 1
      }
    }
  ]
});

/*------------------------------------------------
            MATCH HEIGHT
------------------------------------------------*/

    $('.single #primary .navigation a').matchHeight();
    $('#mustread .entry-container').matchHeight();
    $('#tips .entry-container').matchHeight();
    $('#featured  .entry-container').matchHeight();
    $('#timetable  .timetable-items').matchHeight();
    $('#features .features-item-wrapper .features-content').matchHeight();
    $('.blog-six .blog-posts-wrapper article').matchHeight();
    $('#recent .under-content article .entry-container').matchHeight();
    $('#editorpick .editorpick-wrapper article .entry-container').matchHeight();

/*------------------------------------------------
                Tabs
------------------------------------------------*/

$('#portfolio ul.tabs li').click(function(event) {
    event.preventDefault();

    var tab_id = $(this).attr('data-tab');

    $('#portfolio ul.tabs li').removeClass('active');
    $('#portfolio .tab-content').removeClass('active');
    $('#portfolio .tab-content').fadeOut();
    $(this).addClass('active');
    $("#"+tab_id).fadeIn();

});

$('#gallerypost ul.tabs li').click(function(event) {
    event.preventDefault();

    var tab_id = $(this).attr('data-tab');

    $('#gallerypost ul.tabs li').removeClass('active');
    $('#gallerypost .tab-content').removeClass('active');
    $('#gallerypost .tab-content').fadeOut();
    $(this).addClass('active');
    $("#"+tab_id).fadeIn();

});

$('#details ul.tabs li').click(function(event) {
    event.preventDefault();

    var tab_id = $(this).attr('data-tab');

    $('#details ul.tabs li').removeClass('active');
    $('#details .tab-content').removeClass('active');
    $('#details .tab-content').fadeOut();
    $(this).addClass('active');
    $("#"+tab_id).fadeIn();

});

/*------------------------------------------------
            MASONRY GALLERY
------------------------------------------------*/
    
    masonry_gallery.imagesLoaded( function() {
        masonry_gallery.packery({
            itemSelector: '.grid-item'
        });
    });    
    portfolio_gallery.imagesLoaded( function() {
        portfolio_gallery.packery({
            itemSelector: '.portfolio-grid-item'
        });
    });

/*------------------------------------------------
            Animation
------------------------------------------------*/
function reveal() {
  var reveals = document.querySelectorAll(".animation-enable article");

  for (var i = 0; i < reveals.length; i++) {
    var windowHeight = window.innerHeight;
    var elementTop = reveals[i].getBoundingClientRect().top;
    var elementVisible = 50;

    if (elementTop < windowHeight - elementVisible) {
      reveals[i].classList.add("active");
    } else {
      reveals[i].classList.remove("active");
    }
  }
}

window.addEventListener("scroll", reveal);

/*------------------------------------------------
                END JQUERY
------------------------------------------------*/

});